﻿<?php
ini_set('display_errors','1');
error_reporting(E_ALL);
require __DIR__ . '/../../vendor/autoload.php';
$app = require __DIR__ . '/../../bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

$service = app(App\Services\PdfSlipPrintService::class);
$source = App\Models\SourceFile::find(36);
if (! $source) {
    fwrite(STDERR, "source_file_id 36 not found\n");
    exit(1);
}
$options = [
    'dpi' => 200,
    'cols' => 3,
    'rows' => 0,
    'auto_rows_min' => 5,
    'auto_rows_max' => 6,
    'margin_top' => '0.16',
    'margin_bottom' => '0.06',
    'margin_left' => '0.03',
    'margin_right' => '0.03',
    'inset' => 0.002,
    'box_height_scale' => 1.0,
    'box_pad' => 6,
    'detect_lines' => true,
];
$status = $service->startCropSession($source, 3, 43, $options);
$token = $status['token'] ?? null;
if (! $token) {
    fwrite(STDERR, "token missing\n");
    exit(1);
}
echo "token={$token}\n";
for ($p = 3; $p <= 43; $p++) {
    $service->cropPage($source, $token, $p);
    if ($p % 5 === 0) {
        echo "done page {$p}\n";
    }
}
$manifest = $service->getCropManifest($source, $token);
$page11 = array_values(array_filter($manifest, fn($e) => (int)($e['page'] ?? 0) === 11));
$page12 = array_values(array_filter($manifest, fn($e) => (int)($e['page'] ?? 0) === 12));
echo "page11=".count($page11)." page12=".count($page12)." total=".count($manifest)."\n";
foreach ([155,156,157,158,159,160,161,162,163,164,165,166,167,168] as $s) {
    foreach ($manifest as $e) {
        if ((int)($e['serial'] ?? 0) === $s) {
            echo "{$s} => p{$e['page']} b{$e['block']} {$e['file']}\n";
            break;
        }
    }
}
