<?php
$dir = __DIR__ . '/../app/pdf_slip_crops/sf-36/pdfslip-crop-d10d5210b9d1532d';
$targets = ['page-12-block-0.png','page-12-block-1.png','page-12-block-2.png','page-12-block-3.png','page-12-block-4.png','page-12-block-5.png','page-12-block-6.png','page-12-block-7.png','page-12-block-8.png'];
foreach ($targets as $file) {
    $path = $dir . '/' . $file;
    if (!file_exists($path)) continue;
    $im = imagecreatefrompng($path);
    $w = imagesx($im); $h = imagesy($im);
    $bottomLine = -1;
    for ($y = $h-1; $y >= max(0,$h-40); $y--) {
        $dark = 0; $samples = 0;
        for ($x = 0; $x < $w; $x += 2) {
            $rgb = imagecolorat($im, $x, $y);
            $r = ($rgb >> 16) & 0xFF; $g = ($rgb >> 8) & 0xFF; $b = $rgb & 0xFF;
            if (($r+$g+$b) < 120) $dark++;
            $samples++;
        }
        $ratio = $samples ? ($dark/$samples) : 0;
        if ($ratio > 0.25) { $bottomLine = $y; break; }
    }
    imagedestroy($im);
    echo $file . ' h=' . $h . ' bottomLine=' . $bottomLine . ' margin=' . ($h - 1 - $bottomLine) . PHP_EOL;
}
