﻿

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">সোর্স ফাইলসমূহ</h1>
        <p class="text-muted small mb-0">আপলোড করা ভোটার পিডিএফ ফাইলের তালিকা</p>
    </div>
    <a href="<?php echo e(route('admin.source-files.create')); ?>" class="btn btn-primary">
        <i class="bi bi-upload me-1"></i> নতুন আপলোড
    </a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <?php if(session('status')): ?>
            <div class="alert alert-success"><?php echo e(session('status')); ?></div>
        <?php endif; ?>
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                <tr>
                    <th>#</th>
                    <th>ফাইল নাম</th>
                    <th>এলাকা</th>
                    <th>ইম্পোর্ট</th>
                    <th>তারিখ</th>
                    <th>ভোটার</th>
                    <th class="text-end">কার্যক্রম</th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $sourceFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $status = $file->import_status;
                        if ($status === 'pending' && $file->parsed_successfully) {
                            $status = 'completed';
                        }
                    ?>
                    <tr>
                        <td><?php echo e($file->id); ?></td>
                        <td class="fw-semibold"><?php echo e($file->original_filename); ?></td>
                        <td><?php echo e($file->area->area_name_bn ?? '-'); ?></td>
                        <td>
                            <div class="d-flex flex-column">
                                <?php switch($status):
                                    case ('completed'): ?>
                                        <span class="badge bg-success">সম্পন্ন</span>
                                        <?php break; ?>
                                    <?php case ('failed'): ?>
                                        <span class="badge bg-danger">ব্যর্থ</span>
                                        <?php break; ?>
                                    <?php case ('running'): ?>
                                    <?php case ('queued'): ?>
                                        <span class="badge bg-warning text-dark">চলমান</span>
                                        <?php break; ?>
                                    <?php default: ?>
                                        <span class="badge bg-secondary">পেন্ডিং</span>
                                <?php endswitch; ?>
                                <?php if($file->total_pages): ?>
                                    <small class="text-muted"><?php echo e($file->imported_pages); ?> / <?php echo e($file->total_pages); ?></small>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td><?php echo e(optional($file->import_started_at ?? $file->created_at)->format('d M Y')); ?></td>
                        <td><?php echo e($file->voters_count); ?></td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.source-files.import', $file)); ?>" class="btn btn-sm btn-outline-secondary">
                                ইম্পোর্ট
                            </a>
                            <a href="<?php echo e(route('admin.voters.index', ['source_file_id' => $file->id])); ?>" class="btn btn-sm btn-outline-primary ms-1">
                                ভোটার দেখুন
                            </a>
                            <form action="<?php echo e(route('admin.source-files.destroy', $file)); ?>" method="POST" class="d-inline" onsubmit="return confirm('এই ফাইল ও সংশ্লিষ্ট সব ভোটার ডেটা স্থায়ীভাবে মুছে যাবে। নিশ্চিত করবেন?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-outline-danger ms-1">মুছুন</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted">কোনো সোর্স ফাইল পাওয়া যায়নি</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-2">
            <?php echo e($sourceFiles->withQueryString()->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\github\VoterMaster\resources\views/admin/source_files/index.blade.php ENDPATH**/ ?>