<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Candidate Slip Print</title>
    <style>
        @page { size: A4; margin: 6mm; }
        body { margin: 0; font-family: "Noto Sans Bengali", sans-serif; background: #fff; }
        .print-page { page-break-after: always; padding: 0; }
        .slip-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            grid-template-rows: repeat(5, 1fr);
            gap: 3mm 3mm;
            height: 285mm;
            align-content: stretch;
        }
        .slip {
            border: 1px solid #111;
            padding: 3px;
            break-inside: avoid;
            page-break-inside: avoid;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }
        .slip-header { display: grid; grid-template-columns: 1fr 2fr 1fr; align-items: center; gap: 6px; }
        .slip-header img { width: 100%; height: 34px; object-fit: contain; }
        .slip-header .center { text-align: center; font-size: 10px; line-height: 1.1; }
        .slip-header .name { font-size: 13px; font-weight: 700; }
        .slip-header .location { font-size: 9px; line-height: 1.1; margin-top: 1px; }
        .slip-header .symbol { text-align: center; font-size: 9px; line-height: 1.1; }
        .slip-header .photo { text-align: center; font-size: 9px; line-height: 1.1; }
        .slip-body { flex: 1; min-height: 0; display: flex; align-items: center; justify-content: center; overflow: hidden; }
        .slip-body img { max-width: 100%; max-height: 100%; width: auto; height: auto; object-fit: contain; display: block; }
        .slip-footer { font-size: 8px; text-align: center; margin-top: 1px; color: #333; }
        .page-title { font-size: 11px; color: #333; margin-bottom: 6px; }
        @media print { .print-page:last-child { page-break-after: auto; } }
    </style>
</head>
<body>
<?php
    $chunks = array_chunk($flatFiles ?? [], $perPage);
?>
<?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $printIndex => $chunkFiles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <section class="print-page">
        <div class="page-title">ফাইল: <?php echo e($sourceFile->original_filename); ?> | পেজ: <?php echo e($printIndex + 1); ?></div>
        <div class="slip-grid">
            <?php $__currentLoopData = $chunkFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="slip">
                    <div class="slip-header">
                        <div class="photo">
                            <?php if($candidatePhotoUrl): ?>
                                <img src="<?php echo e($candidatePhotoUrl); ?>" alt="Candidate Photo">
                            <?php endif; ?>
                            <div><?php echo e($candidate->seat_name_bn); ?></div>
                        </div>
                        <div class="center">
                            <?php if($slipHeader): ?>
                                <div><?php echo e($slipHeader); ?></div>
                            <?php endif; ?>
                            <div class="name"><?php echo e($candidate->name_bn); ?></div>
                            <?php if(!empty($locationLine)): ?>
                                <div class="location"><?php echo e($locationLine); ?></div>
                            <?php endif; ?>
                        </div>
                        <div class="symbol">
                            <?php if($candidateSymbolUrl): ?>
                                <img src="<?php echo e($candidateSymbolUrl); ?>" alt="Symbol">
                            <?php endif; ?>
                            <?php if($candidate->symbol_name_bn): ?>
                                <div><?php echo e($candidate->symbol_name_bn); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="slip-body">
                        <?php if(!empty($item['image_url'])): ?>
                            <img src="<?php echo e($item['image_url']); ?>" alt="Voter Slip">
                        <?php endif; ?>
                    </div>
                    <?php if($slipFooter): ?>
                        <div class="slip-footer"><?php echo e($slipFooter); ?></div>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\github\VoterMaster\resources\views/admin/candidate_slip_prints/print.blade.php ENDPATH**/ ?>