<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">PDF থেকে স্লিপ প্রিন্ট</h1>
        <p class="text-muted small mb-0">ডাটাবেজ ছাড়া PDF থেকে সরাসরি স্লিপ ব্লক কেটে প্রিন্ট করুন।</p>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.pdf-slip-print.preview')); ?>" target="_blank">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">সোর্স PDF</label>
                    <select name="source_file_id" class="form-select" required>
                        <option value="">ফাইল নির্বাচন করুন</option>
                        <?php $__currentLoopData = $sourceFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($file->id); ?>" <?php if(old('source_file_id', request('source_file_id')) == $file->id): echo 'selected'; endif; ?>>
                                <?php echo e($file->original_filename); ?><?php if($file->area): ?> - <?php echo e($file->area->area_name_bn); ?><?php endif; ?>
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">শুরু পেজ</label>
                    <input type="number" name="page_from" min="1" value="<?php echo e(old('page_from', 1)); ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">শেষ পেজ</label>
                    <input type="number" name="page_to" min="1" value="<?php echo e(old('page_to', 1)); ?>" class="form-control" required>
                </div>
                <div class="col-md-12">
                    <details class="mt-2">
                        <summary class="small text-muted">অ্যাডভান্সড সেটিংস (প্রয়োজনে)</summary>
                        <div class="row g-3 mt-1">
                            <div class="col-md-2">
                                <label class="form-label">DPI</label>
                                <input type="number" name="dpi" value="<?php echo e(old('dpi', config('votermaster.VM_PDF_SLIP_DPI', 200))); ?>" class="form-control">
                            </div>
                            <input type="hidden" name="cols" value="2">
                            <input type="hidden" name="rows" value="5">
                            <div class="col-md-4 d-flex align-items-end">
                                <div class="small text-muted">
                                    স্লিপ লে-আউট: ২ কলাম × ৫ রো (মোট ১০ স্লিপ/পেজ)
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">টপ মার্জিন</label>
                                <input type="text" name="margin_top" value="<?php echo e(old('margin_top', config('votermaster.VM_PDF_SLIP_MARGIN_TOP', '0.16'))); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">বটম মার্জিন</label>
                                <input type="text" name="margin_bottom" value="<?php echo e(old('margin_bottom', config('votermaster.VM_PDF_SLIP_MARGIN_BOTTOM', '0.06'))); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">বক্স উচ্চতা (গুণ)</label>
                                <input type="text" name="box_height_scale" value="<?php echo e(old('box_height_scale', config('votermaster.VM_PDF_SLIP_BOX_HEIGHT_SCALE', '1.0'))); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">বক্স প্যাড (px)</label>
                                <input type="number" name="box_pad" value="<?php echo e(old('box_pad', config('votermaster.VM_PDF_SLIP_BOX_PAD', 6))); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">ইনসেট</label>
                                <input type="text" name="inset" value="<?php echo e(old('inset', config('votermaster.VM_PDF_SLIP_INSET', 0.002))); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">লেফট মার্জিন</label>
                                <input type="text" name="margin_left" value="<?php echo e(old('margin_left', config('votermaster.VM_PDF_SLIP_MARGIN_LEFT', '0.03'))); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">রাইট মার্জিন</label>
                                <input type="text" name="margin_right" value="<?php echo e(old('margin_right', config('votermaster.VM_PDF_SLIP_MARGIN_RIGHT', '0.03'))); ?>" class="form-control">
                            </div>
                        </div>
                    </details>
                </div>
                <div class="col-md-12 d-flex align-items-end justify-content-end">
                    <button type="submit" class="btn btn-primary">প্রিভিউ &amp; প্রিন্ট</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-start mb-3">
            <div>
                <h2 class="h6 mb-1">PDF থেকে স্লিপ ক্রপ (প্রি-প্রসেস)</h2>
                <p class="text-muted small mb-0">একবার ক্রপ করলে সিরিয়াল রেঞ্জ ধরে দ্রুত প্রিন্ট করা যাবে।</p>
            </div>
        </div>

        <form id="cropForm">
            <?php echo csrf_field(); ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">সোর্স PDF</label>
                    <select name="source_file_id" class="form-select" required>
                        <option value="">ফাইল নির্বাচন করুন</option>
                        <?php $__currentLoopData = $sourceFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($file->id); ?>">
                                <?php echo e($file->original_filename); ?><?php if($file->area): ?> - <?php echo e($file->area->area_name_bn); ?><?php endif; ?>
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">শুরু পেজ</label>
                    <input type="number" name="page_from" min="1" class="form-control" placeholder="ফাঁকা রাখলে ১">
                </div>
                <div class="col-md-3">
                    <label class="form-label">শেষ পেজ</label>
                    <input type="number" name="page_to" min="1" class="form-control" placeholder="ফাঁকা রাখলে শেষ পেজ">
                </div>
                <div class="col-md-12">
                    <details>
                        <summary class="small text-muted">ক্রপ সেটিংস (প্রয়োজনে)</summary>
                        <div class="row g-3 mt-1">
                            <div class="col-md-2">
                                <label class="form-label">DPI</label>
                                <input type="number" name="dpi" value="<?php echo e(config('votermaster.VM_PDF_SLIP_DPI', 200)); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">টপ মার্জিন</label>
                                <input type="text" name="margin_top" value="<?php echo e(config('votermaster.VM_PDF_SLIP_MARGIN_TOP', '0.16')); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">বটম মার্জিন</label>
                                <input type="text" name="margin_bottom" value="<?php echo e(config('votermaster.VM_PDF_SLIP_MARGIN_BOTTOM', '0.06')); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">লেফট মার্জিন</label>
                                <input type="text" name="margin_left" value="<?php echo e(config('votermaster.VM_PDF_SLIP_MARGIN_LEFT', '0.03')); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">রাইট মার্জিন</label>
                                <input type="text" name="margin_right" value="<?php echo e(config('votermaster.VM_PDF_SLIP_MARGIN_RIGHT', '0.03')); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">ইনসেট</label>
                                <input type="text" name="inset" value="<?php echo e(config('votermaster.VM_PDF_SLIP_INSET', 0.002)); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">বক্স উচ্চতা (গুণ)</label>
                                <input type="text" name="box_height_scale" value="<?php echo e(config('votermaster.VM_PDF_SLIP_BOX_HEIGHT_SCALE', '1.0')); ?>" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">বক্স প্যাড (px)</label>
                                <input type="number" name="box_pad" value="<?php echo e(config('votermaster.VM_PDF_SLIP_BOX_PAD', 6)); ?>" class="form-control">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="1" id="detectLines" name="detect_lines" checked>
                                    <label class="form-check-label" for="detectLines">লাইন ডিটেক্ট ব্যবহার (রিকমেন্ডেড)</label>
                                </div>
                            </div>
                            <input type="hidden" name="auto_rows_min" value="5">
                            <input type="hidden" name="auto_rows_max" value="6">
                        </div>
                    </details>
                </div>
                <div class="col-md-12 d-flex align-items-end justify-content-end">
                    <button type="button" id="cropStartBtn" class="btn btn-success">ক্রপ শুরু করুন</button>
                </div>
            </div>
        </form>

        <div id="cropProgressWrap" class="mt-4 d-none">
            <div class="small text-muted mb-1" id="cropStatusText">ক্রপ শুরু হচ্ছে...</div>
            <div class="progress" style="height: 8px;">
                <div class="progress-bar" id="cropProgressBar" style="width: 0%;"></div>
            </div>
            <div class="small text-muted mt-2" id="cropCountText"></div>
        </div>
        <div id="cropError" class="alert alert-danger small mt-3 d-none"></div>

        <div class="border-top mt-4 pt-3">
            <form id="cropPrintForm" method="GET" action="<?php echo e(route('admin.pdf-slip-print.crop.print')); ?>" target="_blank" class="row g-3 align-items-end">
                <input type="hidden" name="source_file_id" id="cropPrintSource">
                <input type="hidden" name="token" id="cropPrintToken">
                <div class="col-md-3">
                    <label class="form-label">সিরিয়াল শুরু</label>
                    <input type="number" name="serial_from" min="1" class="form-control" placeholder="১">
                </div>
                <div class="col-md-3">
                    <label class="form-label">সিরিয়াল শেষ</label>
                    <input type="number" name="serial_to" min="1" class="form-control" placeholder="যেমন 300">
                </div>
                <div class="col-md-6 d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary" disabled id="cropPrintBtn">ক্রপ থেকে প্রিন্ট</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
(() => {
    const startBtn = document.getElementById('cropStartBtn');
    const form = document.getElementById('cropForm');
    const progressWrap = document.getElementById('cropProgressWrap');
    const progressBar = document.getElementById('cropProgressBar');
    const statusText = document.getElementById('cropStatusText');
    const countText = document.getElementById('cropCountText');
    const errorBox = document.getElementById('cropError');
    const printBtn = document.getElementById('cropPrintBtn');
    const printTokenInput = document.getElementById('cropPrintToken');
    const printSourceInput = document.getElementById('cropPrintSource');
    const startUrl = <?php echo json_encode(route('admin.pdf-slip-print.crop.start'), 15, 512) ?>;
    const pageUrl = <?php echo json_encode(route('admin.pdf-slip-print.crop.page'), 15, 512) ?>;
    const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    const setError = (message) => {
        if (! message) {
            errorBox.classList.add('d-none');
            errorBox.textContent = '';
            return;
        }
        errorBox.textContent = message;
        errorBox.classList.remove('d-none');
    };

    const updateProgress = (status) => {
        const total = Number(status.total_pages || 0);
        const done = Number(status.done_pages || 0);
        const percent = total > 0 ? Math.round((done / total) * 100) : 0;
        progressBar.style.width = `${percent}%`;
        statusText.textContent = `ক্রপ চলছে: ${done}/${total} পেজ`;
        const expected = status.expected_blocks || status.total_blocks || 0;
        const actual = status.total_blocks || status.done_blocks || 0;
        countText.textContent = `মোট ক্রপ: ${actual} (প্রগতি ${status.done_blocks || 0} / ${expected})`;
    };

    const postJson = async (url, payload) => {
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': csrf,
            },
            body: JSON.stringify(payload),
        });
        const data = await response.json().catch(() => ({}));
        return { ok: response.ok, data };
    };

    startBtn.addEventListener('click', async () => {
        if (! form.reportValidity()) {
            return;
        }
        setError('');
        startBtn.disabled = true;
        progressWrap.classList.remove('d-none');
        statusText.textContent = 'ক্রপ শুরু হচ্ছে...';
        progressBar.style.width = '0%';
        countText.textContent = '';

        const formData = new FormData(form);
        const payload = Object.fromEntries(formData.entries());
        Object.keys(payload).forEach((key) => {
            if (payload[key] === '') {
                delete payload[key];
            }
        });

        const startResp = await postJson(startUrl, payload);
        if (! startResp.ok) {
            setError(startResp.data.message || 'ক্রপ শুরু করা যায়নি।');
            startBtn.disabled = false;
            return;
        }

        const status = startResp.data;
        updateProgress(status);
        printTokenInput.value = status.token || '';
        printSourceInput.value = payload.source_file_id || '';
        printBtn.disabled = true;

        const pageFrom = Number(status.page_from || 1);
        const pageTo = Number(status.page_to || pageFrom);
        const donePages = new Set((status.pages_done || []).map(Number));

        for (let page = pageFrom; page <= pageTo; page += 1) {
            if (donePages.has(page)) {
                continue;
            }
            statusText.textContent = `পেজ ${page} ক্রপ হচ্ছে...`;
            const pageResp = await postJson(pageUrl, {
                source_file_id: payload.source_file_id,
                token: status.token,
                page: page,
            });
            if (! pageResp.ok) {
                setError(pageResp.data.message || `পেজ ${page} ক্রপ ব্যর্থ হয়েছে।`);
                startBtn.disabled = false;
                return;
            }
            updateProgress(pageResp.data);
        }

        statusText.textContent = 'ক্রপ সম্পন্ন হয়েছে।';
        printBtn.disabled = false;
        startBtn.disabled = false;
    });
})();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\github\VoterMaster\resources\views/admin/pdf_slip_prints/index.blade.php ENDPATH**/ ?>