<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">নতুন পিডিএফ আপলোড</h1>
        <p class="text-muted small mb-0">এলাকা নির্বাচন করুন বা নতুন এলাকা তৈরি করে পিডিএফ আপলোড করুন (ইম্পোর্ট আলাদা ধাপে হবে)।</p>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form action="<?php echo e(route('admin.source-files.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">বিদ্যমান এলাকা</label>
                    <select name="area_id" class="form-select">
                        <option value="">-- নির্বাচন করুন --</option>
                        <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($area->id); ?>" <?php if(old('area_id') == $area->id): echo 'selected'; endif; ?>>
                                <?php echo e($area->area_name_bn); ?> (<?php echo e($area->area_code); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="form-text">অথবা নিচে নতুন এলাকা যোগ করুন</div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">পিডিএফ ফাইল (সর্বোচ্চ ১০০এমবি)</label>
                    <input type="file" name="file" class="form-control" accept=".pdf" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Voter Gender (Existing area)</label>
                    <select name="voter_gender" class="form-select">
                        <option value="">-- Select --</option>
                        <option value="male" <?php if(old('voter_gender') === 'male'): echo 'selected'; endif; ?>>Male</option>
                        <option value="female" <?php if(old('voter_gender') === 'female'): echo 'selected'; endif; ?>>Female</option>
                        <option value="unknown" <?php if(old('voter_gender') === 'unknown'): echo 'selected'; endif; ?>>Unknown</option>
                    </select>
                    <div class="form-text">ইম্পোর্ট করার সময় এই জেন্ডারটি ডিফল্ট হিসেবে থাকবে।</div>
                </div>
                <div class="col-md-12">
                    <label class="form-label">নোট (ঐচ্ছিক)</label>
                    <textarea name="notes" rows="2" class="form-control"><?php echo e(old('notes')); ?></textarea>
                </div>
            </div>

            <hr class="my-4">

            <div class="mb-3">
                <h2 class="h6 mb-1">নতুন এলাকা (ঐচ্ছিক)</h2>
                <p class="text-muted small mb-2">এখানে তথ্য দিলে সেটি দিয়ে নতুন এলাকা তৈরি হবে।</p>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">এলাকা নাম</label>
                        <input type="text" name="new_area[area_name_bn]" value="<?php echo e(old('new_area.area_name_bn')); ?>" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">কেন্দ্রের নাম</label>
                        <input type="text" name="new_area[center_name_bn]" value="<?php echo e(old('new_area.center_name_bn')); ?>" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">জেলা</label>
                        <input type="text" name="new_area[district]" value="<?php echo e(old('new_area.district')); ?>" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">উপজেলা/থানা</label>
                        <input type="text" name="new_area[upazila]" value="<?php echo e(old('new_area.upazila')); ?>" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">ওয়ার্ড</label>
                        <input type="text" name="new_area[ward_no]" value="<?php echo e(old('new_area.ward_no')); ?>" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">কোড</label>
                        <input type="text" name="new_area[area_code]" value="<?php echo e(old('new_area.area_code')); ?>" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">লিঙ্গ প্রকার</label>
                        <select name="new_area[gender_type]" class="form-select">
                            <?php $__currentLoopData = ['male' => 'পুরুষ', 'female' => 'মহিলা', 'mixed' => 'মিশ্র']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php if(old('new_area.gender_type', 'mixed') === $val): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">হেডার টেক্সট</label>
                        <input type="text" name="new_area[raw_header_text]" value="<?php echo e(old('new_area.raw_header_text')); ?>" class="form-control">
                    </div>
                </div>
            </div>

            <div class="d-flex gap-2 mt-3">
                <button type="submit" class="btn btn-primary">আপলোড করুন</button>
                <a href="<?php echo e(route('admin.source-files.index')); ?>" class="btn btn-outline-secondary">বাতিল</a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\github\VoterMaster\resources\views/admin/source_files/create.blade.php ENDPATH**/ ?>