<?php

use App\Http\Controllers\AreaController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CandidateController;
use App\Http\Controllers\CandidateSlipPrintController;
use App\Http\Controllers\CsvFileController;
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PdfSlipPrintController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\SlipPrintController;
use App\Http\Controllers\SourceFileController;
use App\Http\Controllers\VoterController;
use Illuminate\Support\Facades\Route;

Route::redirect('/', '/login');

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
});

Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::middleware(['auth', 'license'])->prefix('admin')->as('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::resource('areas', AreaController::class);
    Route::resource('candidates', CandidateController::class);

    Route::get('profile', [ProfileController::class, 'show'])->name('profile.show');
    Route::put('profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::put('profile/password', [ProfileController::class, 'updatePassword'])->name('profile.password');

    Route::get('settings', [SettingController::class, 'edit'])->name('settings.edit');
    Route::put('settings', [SettingController::class, 'update'])->name('settings.update');

    Route::get('source-files', [SourceFileController::class, 'index'])->name('source-files.index');
    Route::get('source-files/upload', [SourceFileController::class, 'create'])->name('source-files.create');
    Route::post('source-files', [SourceFileController::class, 'store'])->name('source-files.store');
    Route::get('source-files/{sourceFile}/import', [SourceFileController::class, 'importForm'])->name('source-files.import');
    Route::post('source-files/{sourceFile}/import', [SourceFileController::class, 'startImport'])->name('source-files.import.start');
    Route::post('source-files/{sourceFile}/import/stop', [SourceFileController::class, 'stopImport'])->name('source-files.import.stop');
    Route::post('source-files/{sourceFile}/import/restart', [SourceFileController::class, 'restartImport'])->name('source-files.import.restart');
    Route::get('source-files/{sourceFile}/import-status', [SourceFileController::class, 'importStatus'])->name('source-files.import.status');
    Route::delete('source-files/{sourceFile}', [SourceFileController::class, 'destroy'])->name('source-files.destroy');

    Route::get('csv-files', [CsvFileController::class, 'index'])->name('csv-files.index');
    Route::get('csv-files/upload', [CsvFileController::class, 'create'])->name('csv-files.create');
    Route::post('csv-files', [CsvFileController::class, 'store'])->name('csv-files.store');
    Route::get('csv-files/sample', [CsvFileController::class, 'downloadSample'])->name('csv-files.sample');
    Route::delete('csv-files/{sourceFile}', [CsvFileController::class, 'destroy'])->name('csv-files.destroy');

    Route::get('slip-print', [SlipPrintController::class, 'index'])->name('slip-print.index');
    Route::get('slip-print/preview', [SlipPrintController::class, 'preview'])->name('slip-print.preview');
    Route::get('candidate-slip-print', [CandidateSlipPrintController::class, 'index'])->name('candidate-slip-print.index');
    Route::get('candidate-slip-print/preview', [CandidateSlipPrintController::class, 'preview'])->name('candidate-slip-print.preview');
    Route::get('candidate-slip-print/pdf', [CandidateSlipPrintController::class, 'downloadPdf'])->name('candidate-slip-print.pdf');
    Route::get('candidate-slip-print/image/{candidate}/{type}', [CandidateSlipPrintController::class, 'image'])->name('candidate-slip-print.image');
    Route::post('candidate-slip-print/pdf/start', [CandidateSlipPrintController::class, 'startPdfExport'])->name('candidate-slip-print.pdf.start');
    Route::get('candidate-slip-print/pdf/status/{export}', [CandidateSlipPrintController::class, 'exportStatus'])->name('candidate-slip-print.pdf.status');
    Route::post('candidate-slip-print/pdf/cancel/{export}', [CandidateSlipPrintController::class, 'cancelExport'])->name('candidate-slip-print.pdf.cancel');
    Route::get('candidate-slip-print/pdf/download/{export}', [CandidateSlipPrintController::class, 'downloadExport'])->name('candidate-slip-print.pdf.download');
    Route::get('pdf-slip-print', [PdfSlipPrintController::class, 'index'])->name('pdf-slip-print.index');
    Route::get('pdf-slip-print/preview', [PdfSlipPrintController::class, 'preview'])->name('pdf-slip-print.preview');
    Route::get('pdf-slip-print/image/{token}/{file}', [PdfSlipPrintController::class, 'image'])->name('pdf-slip-print.image');
    Route::post('pdf-slip-print/crop/start', [PdfSlipPrintController::class, 'cropStart'])->name('pdf-slip-print.crop.start');
    Route::post('pdf-slip-print/crop/page', [PdfSlipPrintController::class, 'cropPage'])->name('pdf-slip-print.crop.page');
    Route::get('pdf-slip-print/crop/status/{sourceFile}/{token}', [PdfSlipPrintController::class, 'cropStatus'])->name('pdf-slip-print.crop.status');
    Route::get('pdf-slip-print/crop/print', [PdfSlipPrintController::class, 'cropPrint'])->name('pdf-slip-print.crop.print');
    Route::get('pdf-slip-print/crop/image/{sourceFile}/{token}/{file}', [PdfSlipPrintController::class, 'cropImage'])->name('pdf-slip-print.crop.image');
    Route::get('voters/print', [VoterController::class, 'print'])->name('voters.print');
    Route::get('voters/export/pdf', [VoterController::class, 'exportPdf'])->name('voters.export.pdf');
    Route::get('voters/export/csv', [VoterController::class, 'exportCsv'])->name('voters.export.csv');
    Route::patch('voters/{voter}/inline', [VoterController::class, 'inlineUpdate'])->name('voters.inline');
    Route::resource('voters', VoterController::class)->only(['index', 'show', 'create', 'store', 'edit', 'update']);
    Route::get('activity-logs', [ActivityLogController::class, 'index'])->name('activity-logs.index');
});
