<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name') }} - ভোটার ব্যবস্থাপনা সিস্টেম</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        html, body { margin: 0 !important; padding: 0 !important; height: 100%; background: #f6f7fb; }
        body { min-height: 100vh; font-family: "Noto Sans Bengali", sans-serif; }
        .sidebar { width: 240px; min-height: 100vh; }
        .app-shell { min-height: 100vh; margin: 0; }
        .nav-link.active { background: rgba(255,255,255,0.1); border-radius: 8px; }
    </style>
    @stack('styles')
</head>
<body>
<div class="d-flex app-shell">
    <aside class="sidebar bg-dark text-white p-3 d-flex flex-column">
        <div class="d-flex align-items-center mb-4">
            <div class="flex-grow-1">
                <div class="fw-bold text-uppercase small text-muted">VoterMaster</div>
                <div>ভোটার ব্যবস্থাপনা সিস্টেম</div>
            </div>
        </div>
        <nav class="nav flex-column gap-1">
            <a class="nav-link text-white {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" href="{{ route('admin.dashboard') }}">
                <i class="bi bi-speedometer2 me-2"></i> ড্যাশবোর্ড
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.areas.*') ? 'active' : '' }}" href="{{ route('admin.areas.index') }}">
                <i class="bi bi-geo-alt me-2"></i> এলাকা তালিকা
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.candidates.*') ? 'active' : '' }}" href="{{ route('admin.candidates.index') }}">
                <i class="bi bi-person-badge me-2"></i> প্রার্থী
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.source-files.*') ? 'active' : '' }}" href="{{ route('admin.source-files.index') }}">
                <i class="bi bi-file-earmark-arrow-up me-2"></i> পিডিএফ আপলোড
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.pdf-slip-print.*') ? 'active' : '' }}" href="{{ route('admin.pdf-slip-print.index') }}">
                <i class="bi bi-file-earmark-image me-2"></i> পিডিএফ থেকে কাটিং
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.candidate-slip-print.*') ? 'active' : '' }}" href="{{ route('admin.candidate-slip-print.index') }}">
                <i class="bi bi-printer-fill me-2"></i> স্লিপ প্রিন্ট (PDF)
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.csv-files.*') ? 'active' : '' }}" href="{{ route('admin.csv-files.index') }}">
                <i class="bi bi-filetype-csv me-2"></i> CSV আপলোড
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.voters.*') ? 'active' : '' }}" href="{{ route('admin.voters.index') }}">
                <i class="bi bi-people me-2"></i> ভোটার তালিকা
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.slip-print.*') ? 'active' : '' }}" href="{{ route('admin.slip-print.index') }}">
                <i class="bi bi-printer me-2"></i> স্লিপ প্রিন্ট (DB)
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}" href="{{ route('admin.settings.edit') }}">
                <i class="bi bi-gear me-2"></i> সেটিংস
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.profile.*') ? 'active' : '' }}" href="{{ route('admin.profile.show') }}">
                <i class="bi bi-person-circle me-2"></i> প্রোফাইল
            </a>
            <a class="nav-link text-white {{ request()->routeIs('admin.activity-logs.*') ? 'active' : '' }}" href="{{ route('admin.activity-logs.index') }}">
                <i class="bi bi-journal-text me-2"></i> অ্যাক্টিভিটি লগ
            </a>
        </nav>
        <div class="mt-auto pt-4">
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit" class="btn btn-outline-light w-100">
                    <i class="bi bi-box-arrow-right me-1"></i> লগআউট
                </button>
            </form>
        </div>
    </aside>
    <main class="flex-grow-1">
        <div class="bg-white shadow-sm px-4 py-3 d-flex align-items-center justify-content-between">
            <div>
                <div class="small text-muted">প্রশাসনিক প্যানেল</div>
                <h1 class="h5 mb-0">VoterMaster - ভোটার ব্যবস্থাপনা সিস্টেম</h1>
            </div>
            <div class="d-flex align-items-center gap-3">
                <div class="text-end">
                    <div class="fw-semibold">{{ auth()->user()->name ?? 'Admin' }}</div>
                    <div class="text-muted small">{{ auth()->user()->email ?? '' }}</div>
                </div>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="btn btn-sm btn-outline-secondary">লগআউট</button>
                </form>
            </div>
        </div>
        <div class="container-fluid py-4">
            @if (session('status'))
                <div class="alert alert-success small mb-3">
                    {{ session('status') }}
                </div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger small mb-3">
                    <div class="fw-semibold mb-1">ফর্মে সমস্যা আছে</div>
                    <ul class="mb-0 ps-3">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            @yield('content')
            <footer class="text-center text-muted small mt-4">
                &copy; {{ date('Y') }} VoterMaster
            </footer>
        </div>
    </main>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
@stack('scripts')
</body>
</html>

