@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">{{ $voter->name_bn }}</h1>
        <p class="text-muted small mb-0">ভোটার নং: {{ $voter->voter_no }}</p>
    </div>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.voters.edit', $voter) }}" class="btn btn-outline-primary">Edit</a>
        <button onclick="window.print()" class="btn btn-outline-secondary">Print</button>
    </div>
</div>

<div class="row g-3">
    <div class="col-md-8">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <h2 class="h6 mb-3">ব্যক্তিগত তথ্য</h2>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">ক্রমিক</div>
                    <div class="col-sm-8">{{ $voter->serial_no_pdf_bn ?? $voter->serial_no }}</div>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">পিতা</div>
                    <div class="col-sm-8">{{ $voter->father_name_bn }}</div>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">মাতা</div>
                    <div class="col-sm-8">{{ $voter->mother_name_bn }}</div>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">পেশা</div>
                    <div class="col-sm-8">{{ $voter->profession_bn }}</div>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">জন্ম তারিখ</div>
                    @php
                        $bnDigits = ['0'=>'০','1'=>'১','2'=>'২','3'=>'৩','4'=>'৪','5'=>'৫','6'=>'৬','7'=>'৭','8'=>'৮','9'=>'৯'];
                        $dobBn = $voter->date_of_birth_bn ?? (optional($voter->date_of_birth)->format('d-m-Y') ? strtr(optional($voter->date_of_birth)->format('d-m-Y'), $bnDigits) : null);
                    @endphp
                    <div class="col-sm-8">{{ $dobBn }}</div>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">ঠিকানা</div>
                    <div class="col-sm-8">{{ $voter->address_bn }}</div>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4 text-muted small">লিঙ্গ</div>
                    <div class="col-sm-8">
                        @if($voter->gender === 'male') পুরুষ
                        @elseif($voter->gender === 'female') মহিলা
                        @else অজানা @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <h2 class="h6 mb-3">এলাকা তথ্য</h2>
                <div class="small text-muted">এলাকা</div>
                <div class="mb-2">{{ $voter->area->area_name_bn ?? '-' }}</div>
                <div class="small text-muted">ওয়ার্ড/কোড</div>
                <div class="mb-2">{{ $voter->area->ward_no }} {{ $voter->area->area_code ? ' / '.$voter->area->area_code : '' }}</div>
                <div class="small text-muted">সোর্স ফাইল</div>
                <div>{{ $voter->sourceFile->original_filename ?? '-' }}</div>
            </div>
        </div>
    </div>
</div>
@endsection
