<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voter Slips</title>
    <style>
        @page { size: A4; margin: 8mm; }
        body { font-family: "SolaimanLipi", "Noto Sans Bengali", sans-serif; color: #000; margin: 0; }
        .sheet { display: grid; grid-template-columns: repeat(2, 1fr); gap: 4mm 4mm; }
        .slip { border: 1px solid #000; padding: 2.5mm; height: 52mm; box-sizing: border-box; display: flex; flex-direction: column; position: relative; break-inside: avoid; page-break-inside: avoid; }
        .slip-header { text-align: center; font-size: 9px; line-height: 1.2; margin-bottom: 2mm; word-break: break-word; }
        .slip-body { display: flex; gap: 3mm; flex: 1; padding-bottom: 3mm; }
        .slip-left { width: 24mm; display: flex; flex-direction: column; align-items: center; gap: 2.5mm; margin-top: -5mm; }
        .avatar { width: 20mm; height: 20mm; border: 1px solid #000; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; background: #fff; }
        .avatar img { display: block; max-width: 100%; max-height: 100%; width: 100%; height: 100%; object-fit: cover; }
        .avatar.symbol { padding: 1.5mm; box-sizing: border-box; }
        .avatar.symbol img { object-fit: contain; }
        .slip-right { flex: 1; font-size: 9px; line-height: 1.2; display: flex; flex-direction: column; }
        .line { margin-bottom: 1mm; }
        .line.address { display: flex; align-items: flex-start; gap: 1mm; }
        .line.address .label { min-width: 18mm; }
        .line.address .address-value {
            flex: 1;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            max-height: 2.4em;
        }
        .label { display: inline-block; min-width: 18mm; }
        .slip-byline { position: absolute; left: 2.5mm; right: 2.5mm; bottom: 2mm; text-align: right; padding-right: 1mm; font-size: 8px; }
        .slip-serial { position: absolute; right: 1mm; top: 8mm; writing-mode: vertical-rl; transform: rotate(180deg); font-size: 9px; }
    </style>
</head>
<body onload="window.print()">
    <div class="sheet">
        @foreach($voters as $voter)
            @php
                $dob = $voter->date_of_birth_bn ?? optional($voter->date_of_birth)->format('d-m-Y');
                $area = $voter->area;
                $upazila = trim($area?->upazila ?? '');
                $wardNo = trim((string) ($area?->ward_no ?? ''));
                $district = trim($area?->district ?? '');
                $upazilaWard = '';
                if ($upazila !== '' && $wardNo !== '') {
                    $upazilaWard = $upazila.' - '.$wardNo;
                } elseif ($upazila !== '') {
                    $upazilaWard = $upazila;
                } elseif ($wardNo !== '') {
                    $upazilaWard = $wardNo;
                }
                if ($district !== '' && $upazilaWard !== '') {
                    $locationLine = $upazilaWard.', '.$district;
                } elseif ($district !== '') {
                    $locationLine = $district;
                } else {
                    $locationLine = $upazilaWard;
                }
                $topLabel = implode(', ', array_filter([$slipHeader, $locationLine], fn ($value) => $value !== null && $value !== ''));
                $subLabel = $area?->area_name_bn ? 'ভোটার এলাকা: '.$area->area_name_bn : '';
            @endphp
            <div class="slip">
                <div class="slip-serial">ক্রমিক নং {{ $voter->serial_no_pdf_bn ?? $voter->serial_no ?? '-' }}</div>
                <div class="slip-header">
                    @if($topLabel)
                        <div>{{ $topLabel }}</div>
                    @endif
                    @if($subLabel)
                        <div>{{ $subLabel }}</div>
                    @endif
                </div>
                <div class="slip-body">
                    <div class="slip-left">
                        <div class="avatar photo">
                            @if($candidate?->photo_path)
                                <img src="{{ asset('storage/' . $candidate->photo_path) }}" alt="Candidate">
                            @endif
                        </div>
                        <div class="avatar symbol">
                            @if($candidate?->symbol_path)
                                <img src="{{ asset('storage/' . $candidate->symbol_path) }}" alt="Symbol">
                            @endif
                        </div>
                    </div>
                    <div class="slip-right">
                        <div class="line"><span class="label">Name:</span> {{ $voter->name_bn }}</div>
                        <div class="line"><span class="label">Voter No:</span> {{ $voter->voter_no }}</div>
                        <div class="line"><span class="label">Father:</span> {{ $voter->father_name_bn }}</div>
                        <div class="line"><span class="label">Mother:</span> {{ $voter->mother_name_bn }}</div>
                        <div class="line"><span class="label">DOB:</span> {{ $dob }}@if($voter->profession_bn), {{ $voter->profession_bn }}@endif</div>
                        <div class="line address">
                            <span class="label">Address:</span>
                            <span class="address-value">{{ $voter->address_bn }}</span>
                        </div>
                        @if($slipFooter)
                            <div class="slip-byline">{{ $slipFooter }}</div>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</body>
</html>
