<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: sans-serif; color: #000; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #f2f2f2; }
        h2 { margin: 0 0 8px 0; }
    </style>
</head>
<body>
    <h2>VoterMaster – ভোটার তালিকা</h2>
    <table>
        <thead>
        <tr>
            <th>ক্রমিক</th>
            <th>নাম</th>
            <th>ভোটার নং</th>
            <th>পিতা</th>
            <th>মাতা</th>
            <th>পেশা</th>
            <th>জন্মতারিখ</th>
            <th>ঠিকানা</th>
            <th>এলাকা</th>
        </tr>
        </thead>
        <tbody>
        @foreach($voters as $voter)
            <tr>
                <td>{{ $voter->serial_no_pdf_bn ?? $voter->serial_no }}</td>
                <td>{{ $voter->name_bn }}</td>
                <td>{{ $voter->voter_no }}</td>
                <td>{{ $voter->father_name_bn }}</td>
                <td>{{ $voter->mother_name_bn }}</td>
                <td>{{ $voter->profession_bn }}</td>
                @php
                    $bnDigits = ['0'=>'০','1'=>'১','2'=>'২','3'=>'৩','4'=>'৪','5'=>'৫','6'=>'৬','7'=>'৭','8'=>'৮','9'=>'৯'];
                    $dobBn = $voter->date_of_birth_bn ?? (optional($voter->date_of_birth)->format('d-m-Y') ? strtr(optional($voter->date_of_birth)->format('d-m-Y'), $bnDigits) : null);
                @endphp
                <td>{{ $dobBn }}</td>
                <td>{{ $voter->address_bn }}</td>
                <td>{{ $voter->area->area_name_bn ?? '' }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
</body>
</html>
