@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Edit Voter</h1>
        <p class="text-muted small mb-0">Update voter details.</p>
    </div>
    <a href="{{ route('admin.voters.show', $voter) }}" class="btn btn-outline-secondary">Back</a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.voters.update', $voter) }}">
            @csrf
            @method('PUT')
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">ক্রমিক (বাংলা)</label>
                    <input type="text" name="serial_no_pdf_bn" value="{{ old('serial_no_pdf_bn', $voter->serial_no_pdf_bn) }}" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Voter No</label>
                    <input type="text" name="voter_no" value="{{ old('voter_no', $voter->voter_no) }}" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Name (BN)</label>
                    <input type="text" name="name_bn" value="{{ old('name_bn', $voter->name_bn) }}" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Name (EN)</label>
                    <input type="text" name="name_en" value="{{ old('name_en', $voter->name_en) }}" class="form-control">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Father Name (BN)</label>
                    <input type="text" name="father_name_bn" value="{{ old('father_name_bn', $voter->father_name_bn) }}" class="form-control">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Mother Name (BN)</label>
                    <input type="text" name="mother_name_bn" value="{{ old('mother_name_bn', $voter->mother_name_bn) }}" class="form-control">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Profession (BN)</label>
                    <input type="text" name="profession_bn" value="{{ old('profession_bn', $voter->profession_bn) }}" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Date of Birth</label>
                    <input type="date" name="date_of_birth" value="{{ old('date_of_birth', optional($voter->date_of_birth)->format('Y-m-d')) }}" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">DOB (BN)</label>
                    <input type="text" name="date_of_birth_bn" value="{{ old('date_of_birth_bn', $voter->date_of_birth_bn) }}" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Gender</label>
                    <select name="gender" class="form-select" required>
                        @foreach(['male' => 'Male', 'female' => 'Female', 'unknown' => 'Unknown'] as $value => $label)
                            <option value="{{ $value }}" @selected(old('gender', $voter->gender ?? 'unknown') === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Address (BN)</label>
                    <textarea name="address_bn" rows="3" class="form-control">{{ old('address_bn', $voter->address_bn) }}</textarea>
                </div>
            </div>
            <div class="mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary">Save</button>
                <a href="{{ route('admin.voters.show', $voter) }}" class="btn btn-outline-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
