@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">নতুন ভোটার যোগ করুন</h1>
        <p class="text-muted small mb-0">মিসিং ক্রমিক যোগ করে তালিকা ঠিক করুন</p>
    </div>
    <a href="{{ route('admin.voters.index', array_filter(['source_file_id' => request('source_file_id')], fn ($value) => $value !== null && $value !== '')) }}" class="btn btn-outline-secondary">ফিরে যান</a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        @if($sourceFile)
            <div class="alert alert-info small mb-3">
                ফাইল: {{ $sourceFile->original_filename }} |
                এলাকা: {{ $sourceFile->area->area_name_bn ?? '-' }}
            </div>
        @endif

        <form method="POST" action="{{ route('admin.voters.store') }}">
            @csrf
            <div class="row g-3">
                @if($sourceFile)
                    <input type="hidden" name="source_file_id" value="{{ $sourceFile->id }}">
                    <input type="hidden" name="area_id" value="{{ $sourceFile->area_id }}">
                    <div class="col-md-6">
                        <label class="form-label">সোর্স ফাইল</label>
                        <input type="text" class="form-control" value="{{ $sourceFile->original_filename }}" readonly>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">এলাকা</label>
                        <input type="text" class="form-control" value="{{ $sourceFile->area->area_name_bn ?? '' }}" readonly>
                    </div>
                @else
                    <div class="col-md-6">
                        <label class="form-label">সোর্স ফাইল (ঐচ্ছিক)</label>
                        <select name="source_file_id" class="form-select">
                            <option value="">ফাইল নির্বাচন করুন (ঐচ্ছিক)</option>
                            @foreach($sourceFiles as $file)
                                <option value="{{ $file->id }}" @selected(old('source_file_id', $voter->source_file_id) == $file->id)>
                                    {{ $file->original_filename }} ({{ $file->area->area_name_bn ?? 'এলাকা নেই' }})
                                </option>
                            @endforeach
                        </select>
                        <div class="form-text">সোর্স ফাইল দিলে এলাকা অটো সেট হবে।</div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">এলাকা</label>
                        <select name="area_id" class="form-select">
                            <option value="">এলাকা নির্বাচন করুন</option>
                            @foreach($areas as $area)
                                <option value="{{ $area->id }}" @selected(old('area_id', $voter->area_id) == $area->id)>{{ $area->area_name_bn }}</option>
                            @endforeach
                        </select>
                    </div>
                @endif

                <div class="col-md-3">
                    <label class="form-label">ক্রমিক (বাংলা)</label>
                    <input type="text" name="serial_no_pdf_bn" value="{{ old('serial_no_pdf_bn', $voter->serial_no_pdf_bn) }}" class="form-control" placeholder="উদাহরণ: ০৩১" required>
                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" name="shift_later_serials" id="shift_later_serials" value="1" @checked(old('shift_later_serials'))>
                        <label class="form-check-label" for="shift_later_serials">পরের সিরিয়ালগুলো ১ ধাপ সরান</label>
                    </div>
                    <div class="form-text">একই ক্রমিক আগে থেকে থাকলে এই অপশন চালু করুন।</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">ভোটার নং (ঐচ্ছিক)</label>
                    <input type="text" name="voter_no" value="{{ old('voter_no', $voter->voter_no) }}" class="form-control" placeholder="যদি জানা থাকে">
                </div>
                <div class="col-md-3">
                    <label class="form-label">নাম (বাংলা)</label>
                    <input type="text" name="name_bn" value="{{ old('name_bn', $voter->name_bn) }}" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">নাম (ইংরেজি)</label>
                    <input type="text" name="name_en" value="{{ old('name_en', $voter->name_en) }}" class="form-control">
                </div>
                <div class="col-md-4">
                    <label class="form-label">পিতার নাম (বাংলা)</label>
                    <input type="text" name="father_name_bn" value="{{ old('father_name_bn', $voter->father_name_bn) }}" class="form-control">
                </div>
                <div class="col-md-4">
                    <label class="form-label">মাতার নাম (বাংলা)</label>
                    <input type="text" name="mother_name_bn" value="{{ old('mother_name_bn', $voter->mother_name_bn) }}" class="form-control">
                </div>
                <div class="col-md-4">
                    <label class="form-label">পেশা (বাংলা)</label>
                    <input type="text" name="profession_bn" value="{{ old('profession_bn', $voter->profession_bn) }}" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">জন্মতারিখ (বাংলা)</label>
                    <input type="text" name="date_of_birth_bn" value="{{ old('date_of_birth_bn', $voter->date_of_birth_bn) }}" class="form-control" placeholder="০১/০৭/১৯৮৫">
                </div>
                <div class="col-md-3">
                    <label class="form-label">লিঙ্গ</label>
                    <select name="gender" class="form-select">
                        @foreach(['male' => 'পুরুষ', 'female' => 'মহিলা', 'unknown' => 'অজানা'] as $value => $label)
                            <option value="{{ $value }}" @selected(old('gender', $voter->gender ?? 'unknown') === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-12">
                    <label class="form-label">ঠিকানা (বাংলা)</label>
                    <textarea name="address_bn" rows="3" class="form-control">{{ old('address_bn', $voter->address_bn) }}</textarea>
                </div>
            </div>
            <div class="mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary">সংরক্ষণ করুন</button>
                <a href="{{ route('admin.voters.index', array_filter(['source_file_id' => request('source_file_id')], fn ($value) => $value !== null && $value !== '')) }}" class="btn btn-outline-secondary">বাতিল</a>
            </div>
        </form>
    </div>
</div>
@endsection
