@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">ইম্পোর্ট সারাংশ</h1>
        <p class="text-muted small mb-0">ফাইল: {{ $sourceFile->original_filename }}</p>
    </div>
    <a href="{{ route('admin.voters.index', ['source_file_id' => $sourceFile->id]) }}" class="btn btn-outline-primary">
        ভোটার তালিকা দেখুন
    </a>
</div>

<div class="row g-3 mb-3">
    <div class="col-md-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="text-muted small mb-1">মোট ব্লক</div>
                <div class="h5 mb-0">{{ $summary['total_lines'] ?? 0 }}</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="text-muted small mb-1">ইম্পোর্টেড</div>
                <div class="h5 mb-0 text-success">{{ $summary['number_of_voters_parsed'] ?? 0 }}</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="text-muted small mb-1">ব্যর্থ</div>
                <div class="h5 mb-0 text-danger">{{ $summary['number_of_failed_blocks'] ?? 0 }}</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="text-muted small mb-1">স্ট্যাটাস</div>
                @if($sourceFile->parsed_successfully)
                    <span class="badge bg-success">সফল</span>
                @else
                    <span class="badge bg-warning text-dark">ত্রুটি আছে</span>
                @endif
            </div>
        </div>
    </div>
</div>

@if(!empty($summary['error_message']))
    <div class="alert alert-danger">
        {{ $summary['error_message'] }}
    </div>
@endif

@if(!empty($summary['failed_blocks']))
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">
            <h2 class="h6 mb-2">ব্যর্থ ব্লক (ডিবাগ)</h2>
            <ol class="small mb-0">
                @foreach($summary['failed_blocks'] as $block)
                    <li class="mb-2"><pre class="mb-0">{{ $block }}</pre></li>
                @endforeach
            </ol>
        </div>
    </div>
@endif

<a href="{{ route('admin.source-files.index') }}" class="btn btn-secondary">ফাইল তালিকায় ফিরে যান</a>
@endsection
