﻿@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">সোর্স ফাইলসমূহ</h1>
        <p class="text-muted small mb-0">আপলোড করা ভোটার পিডিএফ ফাইলের তালিকা</p>
    </div>
    <a href="{{ route('admin.source-files.create') }}" class="btn btn-primary">
        <i class="bi bi-upload me-1"></i> নতুন আপলোড
    </a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        @if(session('status'))
            <div class="alert alert-success">{{ session('status') }}</div>
        @endif
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                <tr>
                    <th>#</th>
                    <th>ফাইল নাম</th>
                    <th>এলাকা</th>
                    <th>ইম্পোর্ট</th>
                    <th>তারিখ</th>
                    <th>ভোটার</th>
                    <th class="text-end">কার্যক্রম</th>
                </tr>
                </thead>
                <tbody>
                @forelse($sourceFiles as $file)
                    @php
                        $status = $file->import_status;
                        if ($status === 'pending' && $file->parsed_successfully) {
                            $status = 'completed';
                        }
                    @endphp
                    <tr>
                        <td>{{ $file->id }}</td>
                        <td class="fw-semibold">{{ $file->original_filename }}</td>
                        <td>{{ $file->area->area_name_bn ?? '-' }}</td>
                        <td>
                            <div class="d-flex flex-column">
                                @switch($status)
                                    @case('completed')
                                        <span class="badge bg-success">সম্পন্ন</span>
                                        @break
                                    @case('failed')
                                        <span class="badge bg-danger">ব্যর্থ</span>
                                        @break
                                    @case('running')
                                    @case('queued')
                                        <span class="badge bg-warning text-dark">চলমান</span>
                                        @break
                                    @default
                                        <span class="badge bg-secondary">পেন্ডিং</span>
                                @endswitch
                                @if($file->total_pages)
                                    <small class="text-muted">{{ $file->imported_pages }} / {{ $file->total_pages }}</small>
                                @endif
                            </div>
                        </td>
                        <td>{{ optional($file->import_started_at ?? $file->created_at)->format('d M Y') }}</td>
                        <td>{{ $file->voters_count }}</td>
                        <td class="text-end">
                            <a href="{{ route('admin.source-files.import', $file) }}" class="btn btn-sm btn-outline-secondary">
                                ইম্পোর্ট
                            </a>
                            <a href="{{ route('admin.voters.index', ['source_file_id' => $file->id]) }}" class="btn btn-sm btn-outline-primary ms-1">
                                ভোটার দেখুন
                            </a>
                            <form action="{{ route('admin.source-files.destroy', $file) }}" method="POST" class="d-inline" onsubmit="return confirm('এই ফাইল ও সংশ্লিষ্ট সব ভোটার ডেটা স্থায়ীভাবে মুছে যাবে। নিশ্চিত করবেন?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-outline-danger ms-1">মুছুন</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted">কোনো সোর্স ফাইল পাওয়া যায়নি</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-2">
            {{ $sourceFiles->withQueryString()->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
