﻿<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Slip Print</title>
    <style>
        @page { size: A4; margin: 8mm; }
        body { font-family: "SolaimanLipi", "Noto Sans Bengali", sans-serif; color: #000; margin: 0; }
        .sheet { display: grid; grid-template-columns: repeat(2, 1fr); gap: 4mm 4mm; }
        .page-break { page-break-after: always; }
        .slip {
            border: 1px solid #000;
            padding: 2.5mm;
            height: 52mm;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            position: relative;
            break-inside: avoid;
            page-break-inside: avoid;
        }
        .slip-header { text-align: center; font-size: 10pt; font-weight: 400; line-height: 1.2; margin-bottom: 1.5mm; word-break: break-word; }
        .slip-header-label { font-size: 10pt; font-weight: 400; }
        .slip-sub { font-size: 10pt; font-weight: 400; }
        .slip-body { display: flex; gap: 3mm; flex: 1; padding-bottom: 4mm; }
        .slip-left { width: 24mm; display: flex; flex-direction: column; align-items: center; gap: 2mm; margin-top: -2mm; }
        .avatar { width: 16mm; height: 16mm; border: 1px solid #000; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; background: #fff; }
        .avatar img { display: block; width: 100%; height: 100%; object-fit: cover; }
        .avatar.symbol { padding: 1.5mm; box-sizing: border-box; }
        .avatar.symbol img { object-fit: contain; }
        .slip-right { flex: 1; font-size: 9pt; line-height: 1.3; display: flex; flex-direction: column; }
        .line { display: flex; align-items: baseline; gap: 0; margin-bottom: 1mm; }
        .line.address { align-items: flex-start; }
        .line.address .value {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            max-height: 2.6em;
        }
        .label { flex: 0 0 auto; font-weight: 400; margin-right: 0.6mm; }
        .value { flex: 1; }
        .value.name { font-size: 9pt; font-weight: 400; }
        .value.wrap { word-break: break-word; }
        .slip-footer { position: absolute; left: 2.5mm; right: 2.5mm; bottom: 2mm; text-align: right; padding-right: 1mm; font-size: 8.5pt; }
        .slip-serial { position: absolute; right: 1mm; top: 8mm; writing-mode: vertical-rl; transform: rotate(180deg); font-size: 10pt; }
        .empty { font-size: 14pt; text-align: center; margin-top: 40mm; }
    </style>
</head>
<body onload="window.print()">
@if($voters->isEmpty())
    <div class="empty">No voters found for this source file.</div>
@else
    @php
        $area = $sourceFile->area;
        $upazila = trim($area?->upazila ?? '');
        $wardNo = trim((string) ($area?->ward_no ?? ''));
        $district = trim($area?->district ?? '');
        $upazilaWard = '';
        if ($upazila !== '' && $wardNo !== '') {
            $upazilaWard = $upazila.' - '.$wardNo;
        } elseif ($upazila !== '') {
            $upazilaWard = $upazila;
        } elseif ($wardNo !== '') {
            $upazilaWard = $wardNo;
        }
        if ($district !== '' && $upazilaWard !== '') {
            $locationLine = $upazilaWard.', '.$district;
        } elseif ($district !== '') {
            $locationLine = $district;
        } else {
            $locationLine = $upazilaWard;
        }
        $topLabel = implode(', ', array_filter([$slipHeader, $locationLine], fn ($value) => $value !== null && $value !== ''));
        $subLabel = $area?->area_name_bn ? 'ভোটার এলাকা: '.$area->area_name_bn : '';
        $chunks = $voters->chunk($perPage);
    @endphp
    @foreach($chunks as $pageIndex => $pageVoters)
        <div class="sheet {{ $pageIndex < ($chunks->count() - 1) ? 'page-break' : '' }}">
            @foreach($pageVoters as $voter)
                @php
                    $dob = $voter->date_of_birth_bn ?? optional($voter->date_of_birth)->format('d-m-Y');
                @endphp
                <div class="slip">
                    <div class="slip-serial">ক্রমিক নং {{ $voter->serial_no_pdf_bn ?? $voter->serial_no ?? '-' }}</div>
                    <div class="slip-header">
                        @if($topLabel)
                            <div class="slip-header-label">{{ $topLabel }}</div>
                        @endif
                        @if($subLabel)
                            <div class="slip-sub">{{ $subLabel }}</div>
                        @endif
                    </div>
                    <div class="slip-body">
                        <div class="slip-left">
                            <div class="avatar photo">
                                @if($candidate?->photo_path)
                                    <img src="{{ asset('storage/' . $candidate->photo_path) }}" alt="Candidate">
                                @endif
                            </div>
                            <div class="avatar symbol">
                                @if($candidate?->symbol_path)
                                    <img src="{{ asset('storage/' . $candidate->symbol_path) }}" alt="Symbol">
                                @endif
                            </div>
                        </div>
                        <div class="slip-right">
                            <div class="line">
                                <span class="label">নামঃ</span>
                                <span class="value name wrap">{{ $voter->name_bn }}</span>
                            </div>
                            <div class="line">
                                <span class="label">ভোটার নংঃ</span>
                                <span class="value wrap">{{ $voter->voter_no }}</span>
                            </div>
                            <div class="line">
                                <span class="label">পিতাঃ</span>
                                <span class="value wrap">{{ $voter->father_name_bn }}</span>
                            </div>
                            <div class="line">
                                <span class="label">মাতাঃ</span>
                                <span class="value wrap">{{ $voter->mother_name_bn }}</span>
                            </div>
                            <div class="line">
                                <span class="label">জন্ম তারিখঃ</span>
                                <span class="value wrap">{{ $dob }}@if($voter->profession_bn), {{ $voter->profession_bn }}@endif</span>
                            </div>
                            <div class="line address">
                                <span class="label">ঠিকানাঃ</span>
                                <span class="value wrap">{{ $voter->address_bn }}</span>
                            </div>
                            @if($slipFooter)
                                <div class="slip-footer">{{ $slipFooter }}</div>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endforeach
@endif
</body>
</html>

