@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Slip Print</h1>
        <p class="text-muted small mb-0">Select a source PDF, candidate, and how many slips you want to print (10 per page).</p>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.slip-print.preview') }}" target="_blank">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Source PDF</label>
                    <select name="source_file_id" class="form-select" required>
                        <option value="">Select source file</option>
                        @foreach($sourceFiles as $file)
                            <option value="{{ $file->id }}" @selected(old('source_file_id') == $file->id)>
                                {{ $file->original_filename }}@if($file->area) - {{ $file->area->area_name_bn }}@endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Candidate</label>
                    <select name="candidate_id" class="form-select" required>
                        <option value="">Select candidate</option>
                        @foreach($candidates as $candidate)
                            <option value="{{ $candidate->id }}" @selected(old('candidate_id') == $candidate->id)>
                                {{ $candidate->name_bn }}@if($candidate->seat_name_bn) - {{ $candidate->seat_name_bn }}@endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Pages</label>
                    <input type="number" name="pages" min="1" value="{{ old('pages') }}" class="form-control" placeholder="e.g. 5">
                    <div class="form-text">1 page = 10 slips.</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Total Voters</label>
                    <input type="number" name="total_voters" min="1" value="{{ old('total_voters') }}" class="form-control" placeholder="e.g. 50">
                    <div class="form-text">Use either pages or total voters.</div>
                </div>
                <div class="col-md-6 d-flex align-items-end justify-content-end">
                    <button type="submit" class="btn btn-primary">Preview &amp; Print</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
