@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Settings</h1>
        <p class="text-muted small mb-0">Set the global label shown at the top of each slip.</p>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.settings.update') }}">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label class="form-label">Slip Header (Bangla)</label>
                <input type="text" name="slip_header_bn" class="form-control" value="{{ old('slip_header_bn', $slipHeader) }}" placeholder="Enter header text">
                <div class="form-text">Leave empty to hide the header line.</div>
            </div>
            <div class="mb-3">
                <label class="form-label">Slip Footer (Bangla)</label>
                <input type="text" name="slip_footer_bn" class="form-control" value="{{ old('slip_footer_bn', $slipFooter) }}" placeholder="Enter footer text">
                <div class="form-text">Leave empty to hide the footer line.</div>
            </div>
            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
</div>
@endsection
