<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Slip Print from PDF</title>
    <style>
        @page { size: A4; margin: 10mm; }
        body { margin: 0; font-family: "Noto Sans Bengali", sans-serif; background: #fff; }
        .print-page { page-break-after: always; padding: 4mm 0; }
        .slip-grid {
            display: grid;
            grid-template-columns: repeat({{ $options['cols'] }}, 1fr);
            gap: 6mm 6mm;
        }
        .slip {
            border: none;
            padding: 0;
        }
        .slip img {
            width: 100%;
            height: auto;
            display: block;
        }
        .page-title {
            font-size: 12px;
            color: #333;
            margin-bottom: 6px;
        }
        .page-footer {
            font-size: 11px;
            color: #666;
            margin-top: 6px;
            text-align: right;
        }
        @media print {
            .print-page:last-child { page-break-after: auto; }
        }
    </style>
</head>
<body>
@php
    $perPage = 10;
    $flatChunks = array_chunk($flatFiles ?? [], $perPage);
@endphp
@foreach($flatChunks as $printIndex => $chunkFiles)
    <section class="print-page">
        <div class="page-title">
            ফাইল: {{ $sourceFile->original_filename }} | স্লিপ পেজ: {{ $printIndex + 1 }}
        </div>
        <div class="slip-grid">
            @foreach($chunkFiles as $item)
                <div class="slip">
                    <img src="{{ route('admin.pdf-slip-print.image', ['token' => $token, 'file' => $item['file']]) }}" alt="Slip {{ $printIndex + 1 }}">
                </div>
            @endforeach
        </div>
        <div class="page-footer">Page {{ $printIndex + 1 }}</div>
    </section>
@endforeach
</body>
</html>
