@extends('layouts.admin')

@section('content')
<div class="row g-3">
    <div class="col-md-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="text-muted small mb-1">মোট ভোটার</div>
                <div class="h4 mb-0">{{ number_format($totalVoters) }}</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="text-muted small mb-1">মোট এলাকা</div>
                <div class="h4 mb-0">{{ number_format($totalAreas) }}</div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h2 class="h6 mb-0">সাম্প্রতিক আপলোড</h2>
                    <a href="{{ route('admin.source-files.index') }}" class="small">সব দেখুন</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle mb-0">
                        <thead>
                        <tr>
                            <th>ফাইল</th>
                            <th>এলাকা</th>
                            <th>স্ট্যাটাস</th>
                            <th>ভোটার</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($latestFiles as $file)
                            <tr>
                                <td class="fw-semibold">{{ $file->original_filename }}</td>
                                <td>{{ $file->area->area_name_bn ?? '-' }}</td>
                                <td>
                                    @if($file->parsed_successfully)
                                        <span class="badge bg-success">সম্পন্ন</span>
                                    @else
                                        <span class="badge bg-secondary">অপাঠিত</span>
                                    @endif
                                </td>
                                <td>{{ $file->voters_count }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted">কোনো ফাইল নেই</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
