@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">CSV ফাইলসমূহ</h1>
        <p class="text-muted small mb-0">আপলোড করা ভোটার CSV ফাইলের তালিকা</p>
    </div>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.csv-files.sample') }}" class="btn btn-outline-secondary">
            <i class="bi bi-download me-1"></i> স্যাম্পল CSV ডাউনলোড
        </a>
        <a href="{{ route('admin.csv-files.create') }}" class="btn btn-primary">
            <i class="bi bi-upload me-1"></i> নতুন CSV আপলোড
        </a>
    </div>
</div>

@if(session('import_summary'))
    @php $summary = session('import_summary'); @endphp
    <div class="alert alert-info">
        <div class="fw-semibold mb-1">ইম্পোর্ট সারাংশ</div>
        <div class="small">
            মোট সারি: {{ $summary['total_rows'] ?? 0 }},
            ইম্পোর্টেড: {{ $summary['imported_rows'] ?? 0 }},
            ব্যর্থ: {{ $summary['failed_rows'] ?? 0 }}
        </div>
        @if(!empty($summary['failed_samples']))
            <details class="mt-2 small">
                <summary>ব্যর্থ সারির উদাহরণ</summary>
                <ul class="mt-2 mb-0 ps-3">
                    @foreach($summary['failed_samples'] as $sample)
                        <li>{{ implode(' | ', array_filter($sample)) }}</li>
                    @endforeach
                </ul>
            </details>
        @endif
        @if(!empty($summary['error_message']))
            <div class="text-danger small mt-2">{{ $summary['error_message'] }}</div>
        @endif
    </div>
@endif

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                <tr>
                    <th>#</th>
                    <th>ফাইল নাম</th>
                    <th>এলাকা</th>
                    <th>সারি</th>
                    <th>স্ট্যাটাস</th>
                    <th>তারিখ</th>
                    <th>ভোটার</th>
                    <th class="text-end">কার্যক্রম</th>
                </tr>
                </thead>
                <tbody>
                @forelse($sourceFiles as $file)
                    @php
                        $options = $file->import_options ?? [];
                        $totalRows = $options['csv_total_rows'] ?? $file->total_pages ?? 0;
                        $importedRows = $options['csv_imported_rows'] ?? $file->imported_pages ?? 0;
                        $failedRows = $options['csv_failed_rows'] ?? 0;
                        $status = $file->import_status;
                    @endphp
                    <tr>
                        <td>{{ $file->id }}</td>
                        <td class="fw-semibold">{{ $file->original_filename }}</td>
                        <td>{{ $file->area->area_name_bn ?? '-' }}</td>
                        <td>
                            <div class="small">
                                মোট: {{ $totalRows }}
                                <span class="text-muted">| ইম্পোর্টেড: {{ $importedRows }}</span>
                                @if($failedRows)
                                    <span class="text-danger">| ব্যর্থ: {{ $failedRows }}</span>
                                @endif
                            </div>
                        </td>
                        <td>
                            @switch($status)
                                @case('completed')
                                    <span class="badge bg-success">সম্পন্ন</span>
                                    @break
                                @case('failed')
                                    <span class="badge bg-danger">ব্যর্থ</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary">পেন্ডিং</span>
                            @endswitch
                        </td>
                        <td>{{ optional($file->import_started_at ?? $file->created_at)->format('d M Y') }}</td>
                        <td>{{ $file->voters_count }}</td>
                        <td class="text-end">
                            <a href="{{ route('admin.voters.index', ['source_file_id' => $file->id]) }}" class="btn btn-sm btn-outline-primary">
                                ভোটার দেখুন
                            </a>
                            <form action="{{ route('admin.csv-files.destroy', $file) }}" method="POST" class="d-inline" onsubmit="return confirm('এই CSV ফাইল ও সংশ্লিষ্ট সব ভোটার ডেটা স্থায়ীভাবে মুছে যাবে। নিশ্চিত করবেন?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-outline-danger ms-1">মুছুন</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted">কোনো CSV ফাইল পাওয়া যায়নি</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-2">
            {{ $sourceFiles->withQueryString()->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
