@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">নতুন CSV আপলোড</h1>
        <p class="text-muted small mb-0">এলাকা নির্বাচন করে CSV ফাইল আপলোড করুন।</p>
    </div>
    <a href="{{ route('admin.csv-files.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left me-1"></i> তালিকায় ফিরে যান
    </a>
</div>

<div class="alert alert-info small">
    <div class="fw-semibold mb-1">CSV কলামসমূহ</div>
    <code>serial_no_pdf_bn,voter_no,name_bn,father_name_bn,mother_name_bn,profession_bn,date_of_birth_bn,address_bn</code>
    <div class="mt-1">তারিখ ফরম্যাট: ০১/০৭/১৯৮৫</div>
    <div class="mt-1 text-muted">Excel ব্যবহার করলে <strong>voter_no</strong> কলাম Text ফরম্যাট দিন। স্যাম্পল ফাইলে এই কলাম <code>="৩৩০৬৪১১৪০১৬৮"</code> ফরম্যাটে দেওয়া আছে।</div>
    <a href="{{ route('admin.csv-files.sample') }}" class="d-inline-block mt-2">
        <i class="bi bi-download me-1"></i> স্যাম্পল CSV ডাউনলোড
    </a>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form action="{{ route('admin.csv-files.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">বিদ্যমান এলাকা</label>
                    <select name="area_id" class="form-select">
                        <option value="">-- নির্বাচন করুন --</option>
                        @foreach($areas as $area)
                            <option value="{{ $area->id }}" @selected(old('area_id') == $area->id)>
                                {{ $area->area_name_bn }} ({{ $area->area_code }})
                            </option>
                        @endforeach
                    </select>
                    <div class="form-text">অথবা নিচে নতুন এলাকা যোগ করুন</div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">CSV ফাইল (সর্বোচ্চ ২০ এমবি)</label>
                    <input type="file" name="file" class="form-control" accept=".csv" required>
                </div>
                <div class="col-md-12">
                    <label class="form-label">নোট (ঐচ্ছিক)</label>
                    <textarea name="notes" rows="2" class="form-control">{{ old('notes') }}</textarea>
                </div>
            </div>

            <hr class="my-4">

            <div class="mb-3">
                <h2 class="h6 mb-1">নতুন এলাকা (ঐচ্ছিক)</h2>
                <p class="text-muted small mb-2">এখানে তথ্য দিলে সেটি দিয়ে নতুন এলাকা তৈরি হবে।</p>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">এলাকার নাম</label>
                        <input type="text" name="new_area[area_name_bn]" value="{{ old('new_area.area_name_bn') }}" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">কেন্দ্রের নাম</label>
                        <input type="text" name="new_area[center_name_bn]" value="{{ old('new_area.center_name_bn') }}" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">জেলা</label>
                        <input type="text" name="new_area[district]" value="{{ old('new_area.district') }}" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">উপজেলা/থানা</label>
                        <input type="text" name="new_area[upazila]" value="{{ old('new_area.upazila') }}" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">ওয়ার্ড</label>
                        <input type="text" name="new_area[ward_no]" value="{{ old('new_area.ward_no') }}" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">কোড</label>
                        <input type="text" name="new_area[area_code]" value="{{ old('new_area.area_code') }}" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">লিঙ্গ প্রকার</label>
                        <select name="new_area[gender_type]" class="form-select">
                            @foreach(['male' => 'পুরুষ', 'female' => 'মহিলা', 'mixed' => 'মিশ্র'] as $val => $label)
                                <option value="{{ $val }}" @selected(old('new_area.gender_type', 'mixed') === $val)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">হেডার টেক্সট</label>
                        <input type="text" name="new_area[raw_header_text]" value="{{ old('new_area.raw_header_text') }}" class="form-control">
                    </div>
                </div>
            </div>

            <div class="d-flex gap-2 mt-3">
                <button type="submit" class="btn btn-primary">আপলোড করুন</button>
                <a href="{{ route('admin.csv-files.index') }}" class="btn btn-outline-secondary">বাতিল</a>
            </div>
        </form>
    </div>
</div>
@endsection
