@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Candidate Details</h1>
        <p class="text-muted small mb-0">Review candidate profile and assets.</p>
    </div>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.candidates.edit', $candidate) }}" class="btn btn-outline-primary">Edit</a>
        <a href="{{ route('admin.candidates.index') }}" class="btn btn-outline-secondary">Back</a>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="row g-4">
            <div class="col-md-4">
                <div class="text-muted small mb-2">Candidate Photo</div>
                @if($candidate->photo_path)
                    <img src="{{ asset('storage/' . $candidate->photo_path) }}" alt="Candidate photo" style="width:140px;height:140px;border-radius:50%;object-fit:cover;border:1px solid #ddd;">
                @else
                    <div class="text-muted">No photo uploaded.</div>
                @endif
            </div>
            <div class="col-md-4">
                <div class="text-muted small mb-2">Symbol</div>
                @if($candidate->symbol_path)
                    <img src="{{ asset('storage/' . $candidate->symbol_path) }}" alt="Symbol" style="width:140px;height:140px;object-fit:contain;border:1px solid #ddd;">
                @else
                    <div class="text-muted">No symbol uploaded.</div>
                @endif
            </div>
            <div class="col-md-4">
                <div class="text-muted small">Name (BN)</div>
                <div class="fw-semibold mb-2">{{ $candidate->name_bn }}</div>

                <div class="text-muted small">Seat Name (BN)</div>
                <div class="mb-2">{{ $candidate->seat_name_bn ?? '-' }}</div>

                <div class="text-muted small">Symbol Name (BN)</div>
                <div class="mb-2">{{ $candidate->symbol_name_bn ?? '-' }}</div>

                <div class="text-muted small">Status</div>
                <div>
                    @if($candidate->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-secondary">Inactive</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
