@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Candidates</h1>
        <p class="text-muted small mb-0">Manage candidate photos and symbols for slip printing.</p>
    </div>
    <a href="{{ route('admin.candidates.create') }}" class="btn btn-primary">Add Candidate</a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                <tr>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Seat</th>
                    <th>Symbol</th>
                    <th>Status</th>
                    <th class="text-end">Actions</th>
                </tr>
                </thead>
                <tbody>
                @forelse($candidates as $candidate)
                    <tr>
                        <td>
                            @if($candidate->photo_path)
                                <img src="{{ asset('storage/' . $candidate->photo_path) }}" alt="Photo" style="height:40px;width:40px;border-radius:50%;object-fit:cover;">
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td class="fw-semibold">{{ $candidate->name_bn }}</td>
                        <td>{{ $candidate->seat_name_bn ?? '-' }}</td>
                        <td>
                            <div class="d-flex align-items-center gap-2">
                                @if($candidate->symbol_path)
                                    <img src="{{ asset('storage/' . $candidate->symbol_path) }}" alt="Symbol" style="height:32px;width:32px;object-fit:contain;">
                                @endif
                                <span>{{ $candidate->symbol_name_bn ?? '-' }}</span>
                            </div>
                        </td>
                        <td>
                            @if($candidate->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.candidates.show', $candidate) }}" class="btn btn-sm btn-outline-secondary">View</a>
                            <a href="{{ route('admin.candidates.edit', $candidate) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                            <form method="POST" action="{{ route('admin.candidates.destroy', $candidate) }}" class="d-inline" onsubmit="return confirm('Delete this candidate?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted">No candidates found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-2">
            {{ $candidates->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
