@csrf
<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label">Candidate Name (BN)</label>
        <input type="text" name="name_bn" value="{{ old('name_bn', $candidate->name_bn) }}" class="form-control" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Seat Name (BN)</label>
        <input type="text" name="seat_name_bn" value="{{ old('seat_name_bn', $candidate->seat_name_bn) }}" class="form-control">
    </div>
    <div class="col-md-6">
        <label class="form-label">Symbol Name (BN)</label>
        <input type="text" name="symbol_name_bn" value="{{ old('symbol_name_bn', $candidate->symbol_name_bn) }}" class="form-control">
    </div>
    <div class="col-md-6">
        <label class="form-label">Active</label>
        @php
            $isActive = old('is_active', $candidate->is_active ?? true) ? true : false;
        @endphp
        <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" @checked($isActive)>
            <label class="form-check-label" for="is_active">Yes</label>
        </div>
    </div>
    <div class="col-md-6">
        <label class="form-label">Candidate Photo</label>
        <input type="file" name="photo" class="form-control" accept="image/*">
        @if($candidate->photo_path)
            <div class="mt-2">
                <img src="{{ asset('storage/' . $candidate->photo_path) }}" alt="Candidate photo" style="height:64px;width:64px;object-fit:cover;border-radius:50%;border:1px solid #ddd;">
            </div>
        @endif
    </div>
    <div class="col-md-6">
        <label class="form-label">Symbol Image</label>
        <input type="file" name="symbol_image" class="form-control" accept="image/*">
        @if($candidate->symbol_path)
            <div class="mt-2">
                <img src="{{ asset('storage/' . $candidate->symbol_path) }}" alt="Symbol" style="height:64px;width:64px;object-fit:contain;border:1px solid #ddd;">
            </div>
        @endif
    </div>
</div>
<div class="mt-4 d-flex gap-2">
    <button type="submit" class="btn btn-primary">Save</button>
    <a href="{{ route('admin.candidates.index') }}" class="btn btn-outline-secondary">Back</a>
</div>
