<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    @php
        $fontRegular = str_replace('\\', '/', public_path('fonts/NotoSansBengali-Regular.ttf'));
        $fontBold = str_replace('\\', '/', public_path('fonts/NotoSansBengali-Bold.ttf'));
    @endphp
    <style>
        @font-face {
            font-family: "NotoSansBengali";
            font-style: normal;
            font-weight: normal;
            src: url("file:///{{ $fontRegular }}") format("truetype");
        }
        @font-face {
            font-family: "NotoSansBengali";
            font-style: normal;
            font-weight: bold;
            src: url("file:///{{ $fontBold }}") format("truetype");
        }
        @page { size: A4; margin: 6mm; }
        body { margin: 0; font-family: "NotoSansBengali", sans-serif; background: #fff; }
        .print-page { page-break-after: always; padding: 0; }
        .slip-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            grid-template-rows: repeat(5, 1fr);
            gap: 3mm 3mm;
            height: 285mm;
            align-content: stretch;
        }
        .slip {
            border: 1px solid #111;
            padding: 3px;
            page-break-inside: avoid;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }
        .slip-header { display: grid; grid-template-columns: 1fr 2fr 1fr; align-items: center; gap: 6px; }
        .slip-header img { width: 100%; height: 34px; object-fit: contain; }
        .slip-header .center { text-align: center; font-size: 10px; line-height: 1.1; }
        .slip-header .name { font-size: 13px; font-weight: 700; }
        .slip-header .location { font-size: 9px; line-height: 1.1; margin-top: 1px; }
        .slip-header .symbol { text-align: center; font-size: 9px; line-height: 1.1; }
        .slip-header .photo { text-align: center; font-size: 9px; line-height: 1.1; }
        .slip-body { flex: 1; min-height: 0; display: flex; align-items: center; justify-content: center; overflow: hidden; }
        .slip-body img { max-width: 100%; max-height: 100%; width: auto; height: auto; object-fit: contain; display: block; }
        .slip-footer { font-size: 8px; text-align: center; margin-top: 1px; color: #333; }
    </style>
</head>
<body>
@php
    $chunks = array_chunk($flatFiles ?? [], $perPage);
@endphp
@foreach($chunks as $chunkFiles)
    <section class="print-page">
        <div class="slip-grid">
            @foreach($chunkFiles as $item)
                <div class="slip">
                    <div class="slip-header">
                        <div class="photo">
                            @if($candidatePhotoUrl)
                                <img src="{{ $candidatePhotoUrl }}" alt="Candidate Photo">
                            @endif
                            <div>{{ $candidate->seat_name_bn }}</div>
                        </div>
                        <div class="center">
                            @if($slipHeader)
                                <div>{{ $slipHeader }}</div>
                            @endif
                            <div class="name">{{ $candidate->name_bn }}</div>
                            @if(!empty($locationLine))
                                <div class="location">{{ $locationLine }}</div>
                            @endif
                        </div>
                        <div class="symbol">
                            @if($candidateSymbolUrl)
                                <img src="{{ $candidateSymbolUrl }}" alt="Symbol">
                            @endif
                            @if($candidate->symbol_name_bn)
                                <div>{{ $candidate->symbol_name_bn }}</div>
                            @endif
                        </div>
                    </div>
                    <div class="slip-body">
                        @if(!empty($item['image_url']))
                            <img src="{{ $item['image_url'] }}" alt="Voter Slip">
                        @endif
                    </div>
                    @if($slipFooter)
                        <div class="slip-footer">{{ $slipFooter }}</div>
                    @endif
                </div>
            @endforeach
        </div>
    </section>
@endforeach
</body>
</html>
