@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Candidate Slip Print</h1>
        <p class="text-muted small mb-0">ক্রপ করা PDF স্লিপ থেকে প্রার্থী ভিত্তিক প্রিন্ট করুন।</p>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.candidate-slip-print.preview') }}" target="_blank" id="candidateSlipForm">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">প্রার্থী</label>
                    <select name="candidate_id" class="form-select" required>
                        <option value="">প্রার্থী নির্বাচন করুন</option>
                        @foreach($candidates as $candidate)
                            <option value="{{ $candidate->id }}">{{ $candidate->name_bn }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">সোর্স PDF</label>
                    <select name="source_file_id" class="form-select" required>
                        <option value="">ফাইল নির্বাচন করুন</option>
                        @foreach($sourceFiles as $file)
                            <option value="{{ $file->id }}">{{ $file->original_filename }}@if($file->area) - {{ $file->area->area_name_bn }}@endif</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">সিরিয়াল শুরু</label>
                    <input type="number" name="serial_from" min="1" class="form-control" placeholder="১">
                </div>
                <div class="col-md-2">
                    <label class="form-label">সিরিয়াল শেষ</label>
                    <input type="number" name="serial_to" min="1" class="form-control" placeholder="যেমন 300">
                </div>
                <div class="col-md-12 d-flex align-items-end justify-content-end gap-2">
                    <button type="submit" class="btn btn-primary">Batch/Chunk Print (HTML)</button>
                    <button type="button" class="btn btn-outline-primary" id="startPdfBtn">Server PDF Generate</button>
                </div>
                <div class="col-md-12">
                    <div class="small text-muted">
                        বড় ডাটার জন্য ৩০০–৫০০ করে ব্যাচ দিন, এতে ব্রাউজার স্লো হবে না।
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm border-0 mt-3 d-none" id="pdfProgressCard">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="fw-semibold">PDF জেনারেশন প্রোগ্রেস</div>
            <button class="btn btn-sm btn-outline-danger" id="stopPdfBtn">Stop</button>
        </div>
        <div class="progress" style="height: 8px;">
            <div class="progress-bar" id="pdfProgressBar" style="width: 0%;"></div>
        </div>
        <div class="small text-muted mt-2" id="pdfProgressText">শুরু হচ্ছে...</div>
        <div class="mt-3 d-none" id="pdfDownloadWrap">
            <a class="btn btn-success" id="pdfDownloadBtn" href="#" target="_blank">Download PDF</a>
        </div>
        <div class="alert alert-danger small mt-3 d-none" id="pdfErrorBox"></div>
    </div>
</div>
@endsection

@push('scripts')
<script>
(() => {
    const form = document.getElementById('candidateSlipForm');
    const startBtn = document.getElementById('startPdfBtn');
    const card = document.getElementById('pdfProgressCard');
    const bar = document.getElementById('pdfProgressBar');
    const text = document.getElementById('pdfProgressText');
    const stopBtn = document.getElementById('stopPdfBtn');
    const downloadWrap = document.getElementById('pdfDownloadWrap');
    const downloadBtn = document.getElementById('pdfDownloadBtn');
    const errorBox = document.getElementById('pdfErrorBox');
    const startUrl = @json(route('admin.candidate-slip-print.pdf.start'));
    const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    let currentExportId = null;
    let pollTimer = null;

    const setError = (message) => {
        if (!message) {
            errorBox.classList.add('d-none');
            errorBox.textContent = '';
            return;
        }
        errorBox.textContent = message;
        errorBox.classList.remove('d-none');
    };

    const pollStatus = async () => {
        if (!currentExportId) return;
        const response = await fetch(`${startUrl.replace('/start','')}/status/${currentExportId}`);
        const data = await response.json();
        bar.style.width = `${data.progress || 0}%`;
        text.textContent = `স্ট্যাটাস: ${data.status} (${data.progress || 0}%)`;

        if (data.status === 'done') {
            downloadBtn.href = data.download_url;
            downloadWrap.classList.remove('d-none');
            stopBtn.disabled = true;
            clearInterval(pollTimer);
        } else if (data.status === 'failed' || data.status === 'canceled') {
            setError(data.message || 'PDF জেনারেশন বন্ধ/ব্যর্থ হয়েছে।');
            stopBtn.disabled = true;
            clearInterval(pollTimer);
        }
    };

    startBtn.addEventListener('click', async () => {
        if (!form.reportValidity()) return;
        setError('');
        downloadWrap.classList.add('d-none');
        stopBtn.disabled = false;
        card.classList.remove('d-none');
        bar.style.width = '0%';
        text.textContent = 'PDF জেনারেশন শুরু হচ্ছে...';

        const formData = new FormData(form);
        const payload = Object.fromEntries(formData.entries());
        const response = await fetch(startUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': csrf,
            },
            body: JSON.stringify(payload),
        });
        const data = await response.json();
        if (!response.ok) {
            setError(data.message || 'PDF জেনারেশন শুরু করা যায়নি।');
            return;
        }
        currentExportId = data.export_id;
        pollTimer = setInterval(pollStatus, 2000);
        pollStatus();
    });

    stopBtn.addEventListener('click', async () => {
        if (!currentExportId) return;
        await fetch(`${startUrl.replace('/start','')}/cancel/${currentExportId}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': csrf,
                'Accept': 'application/json',
            },
        });
        text.textContent = 'ক্যান্সেল করা হচ্ছে...';
    });
})();
</script>
@endpush
