@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">এলাকা তালিকা</h1>
        <p class="text-muted small mb-0">ড্যাশবোর্ড > এলাকা ব্যবস্থাপনা</p>
    </div>
    <a href="{{ route('admin.areas.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i> নতুন এলাকা
    </a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                <tr>
                    <th>নাম</th>
                    <th>কেন্দ্রের নাম</th>
                    <th>জেলা/উপজেলা</th>
                    <th>ওয়ার্ড/কোড</th>
                    <th>লিঙ্গ</th>
                    <th class="text-end">অ্যাকশন</th>
                </tr>
                </thead>
                <tbody>
                @forelse($areas as $area)
                    <tr>
                        <td class="fw-semibold">{{ $area->area_name_bn ?? '-' }}</td>
                        <td>{{ $area->center_name_bn ?? '-' }}</td>
                        <td>{{ $area->district }} {{ $area->upazila ? ' / '.$area->upazila : '' }}</td>
                        <td>{{ $area->ward_no }} {{ $area->area_code ? ' / '.$area->area_code : '' }}</td>
                        <td>
                            @if($area->gender_type === 'male') পুরুষ
                            @elseif($area->gender_type === 'female') মহিলা
                            @else মিশ্র @endif
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.areas.edit', $area) }}" class="btn btn-sm btn-outline-primary">সম্পাদনা</a>
                            <form action="{{ route('admin.areas.destroy', $area) }}" method="POST" class="d-inline" onsubmit="return confirm('মুছে ফেলতে চান?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-outline-danger">মুছুন</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted">কোনো এলাকা যোগ করা হয়নি</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-2">
            {{ $areas->withQueryString()->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
