@csrf
<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label">জেলা</label>
        <input type="text" name="district" value="{{ old('district', $area->district) }}" class="form-control">
    </div>
    <div class="col-md-6">
        <label class="form-label">উপজেলা/থানা</label>
        <input type="text" name="upazila" value="{{ old('upazila', $area->upazila) }}" class="form-control">
    </div>
    <div class="col-md-6">
        <label class="form-label">সিটি কর্পোরেশন</label>
        <input type="text" name="city_corporation" value="{{ old('city_corporation', $area->city_corporation) }}" class="form-control">
    </div>
    <div class="col-md-3">
        <label class="form-label">ওয়ার্ড নং</label>
        <input type="text" name="ward_no" value="{{ old('ward_no', $area->ward_no) }}" class="form-control">
    </div>
    <div class="col-md-3">
        <label class="form-label">এরিয়া কোড</label>
        <input type="text" name="area_code" value="{{ old('area_code', $area->area_code) }}" class="form-control">
    </div>
    <div class="col-md-6">
        <label class="form-label">এলাকার নাম (বাংলা)</label>
        <input type="text" name="area_name_bn" value="{{ old('area_name_bn', $area->area_name_bn) }}" class="form-control" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">কেন্দ্রের নাম</label>
        <input type="text" name="center_name_bn" value="{{ old('center_name_bn', $area->center_name_bn) }}" class="form-control">
    </div>
    <div class="col-md-6">
        <label class="form-label">লিঙ্গ প্রকার</label>
        <select name="gender_type" class="form-select" required>
            @foreach(['male' => 'পুরুষ', 'female' => 'মহিলা', 'mixed' => 'মিশ্র'] as $value => $label)
                <option value="{{ $value }}" @selected(old('gender_type', $area->gender_type ?? 'mixed') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-12">
        <label class="form-label">হেডার টেক্সট</label>
        <textarea name="raw_header_text" rows="2" class="form-control">{{ old('raw_header_text', $area->raw_header_text) }}</textarea>
    </div>
    <div class="col-md-4">
        <label class="form-label">মোট ভোটার (ঐচ্ছিক)</label>
        <input type="number" name="total_voters" value="{{ old('total_voters', $area->total_voters) }}" class="form-control">
    </div>
</div>
<div class="mt-4 d-flex gap-2">
    <button type="submit" class="btn btn-primary">সংরক্ষণ করুন</button>
    <a href="{{ route('admin.areas.index') }}" class="btn btn-outline-secondary">বাতিল</a>
</div>
