@extends('layouts.admin')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="h5 mb-0">Activity Log</h1>
        <p class="text-muted small mb-0">Recent changes (voter edits only).</p>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.activity-logs.index') }}">
            <div class="row g-2 align-items-end">
                <div class="col-md-3">
                    <label class="form-label">Search</label>
                    <input type="text" name="q" value="{{ request('q') }}" class="form-control" placeholder="User, action, subject...">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Action</label>
                    <input type="text" name="action" value="{{ request('action') }}" class="form-control" placeholder="voter.updated">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Subject ID</label>
                    <input type="number" name="subject_id" value="{{ request('subject_id') }}" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">From</label>
                    <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To</label>
                    <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                </div>
                <div class="col-md-1 text-end">
                    <button type="submit" class="btn btn-primary">Filter</button>
                </div>
                <div class="col-md-12 text-end">
                    <a href="{{ route('admin.activity-logs.index') }}" class="btn btn-outline-secondary btn-sm">Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                <tr>
                    <th>Time</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>Subject</th>
                    <th>Changes</th>
                </tr>
                </thead>
                <tbody>
                @forelse($logs as $log)
                    <tr>
                        <td class="text-muted small">{{ optional($log->created_at)->format('Y-m-d H:i') }}</td>
                        <td>{{ $log->actor?->name ?? 'System' }}</td>
                        <td>{{ $log->action }}</td>
                        <td>{{ class_basename($log->subject_type) }} #{{ $log->subject_id }}</td>
                        <td>
                            @if($log->changes)
                                <ul class="mb-0 ps-3 small">
                                    @foreach($log->changes as $field => $change)
                                        @php
                                            $from = $change['from'] ?? null;
                                            $to = $change['to'] ?? null;
                                            $from = is_array($from) ? json_encode($from) : $from;
                                            $to = is_array($to) ? json_encode($to) : $to;
                                        @endphp
                                        <li>{{ $field }}: {{ $from }} => {{ $to }}</li>
                                    @endforeach
                                </ul>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted">No activity yet.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-2">
            {{ $logs->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
