<?php

namespace Database\Seeders;

use App\Models\Area;
use App\Models\SourceFile;
use App\Models\User;
use App\Models\Voter;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $admin = User::factory()->create([
            'name' => 'VoterMaster Admin',
            'email' => 'admin@votermaster.test',
            'password' => bcrypt('password'),
            'is_admin' => true,
        ]);

        $area = Area::factory()->create([
            'area_name_bn' => 'নয়ানগাঁও',
            'gender_type' => 'mixed',
            'area_code' => '0641',
            'raw_header_text' => 'গাজীপুর সদর, নয়ানগাঁও',
        ]);

        $sourceFile = SourceFile::factory()->create([
            'area_id' => $area->id,
            'original_filename' => 'sample.pdf',
            'stored_path' => 'voter_pdfs/sample.pdf',
            'parsed_successfully' => true,
        ]);

        Voter::factory(5)->create([
            'area_id' => $area->id,
            'source_file_id' => $sourceFile->id,
        ]);
    }
}
