<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pdf_exports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('source_file_id')->constrained()->cascadeOnDelete();
            $table->foreignId('candidate_id')->constrained()->cascadeOnDelete();
            $table->unsignedInteger('serial_from')->default(1);
            $table->unsignedInteger('serial_to')->nullable();
            $table->unsignedInteger('total_slips')->default(0);
            $table->unsignedInteger('processed_slips')->default(0);
            $table->unsignedTinyInteger('progress')->default(0);
            $table->string('status')->default('pending');
            $table->string('file_path')->nullable();
            $table->text('message')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('finished_at')->nullable();
            $table->timestamp('canceled_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pdf_exports');
    }
};
