<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('source_files', function (Blueprint $table) {
            $table->string('import_status')->default('pending')->after('notes');
            $table->unsignedInteger('imported_pages')->default(0)->after('import_status');
            $table->unsignedInteger('total_pages')->nullable()->after('imported_pages');
            $table->timestamp('import_started_at')->nullable()->after('total_pages');
            $table->timestamp('import_finished_at')->nullable()->after('import_started_at');
            $table->json('import_options')->nullable()->after('import_finished_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('source_files', function (Blueprint $table) {
            $table->dropColumn([
                'import_status',
                'imported_pages',
                'total_pages',
                'import_started_at',
                'import_finished_at',
                'import_options',
            ]);
        });
    }
};
