<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('voters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('area_id')->constrained()->cascadeOnDelete();
            $table->foreignId('source_file_id')->nullable()->constrained('source_files')->nullOnDelete();
            $table->integer('serial_no')->nullable();
            $table->string('voter_no')->index();
            $table->string('name_bn');
            $table->string('name_en')->nullable();
            $table->string('father_name_bn')->nullable()->index();
            $table->string('mother_name_bn')->nullable();
            $table->string('profession_bn')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('address_bn')->nullable();
            $table->enum('gender', ['male', 'female', 'unknown'])->default('unknown');
            $table->json('extra_json')->nullable();
            $table->timestamps();

            $table->index('name_bn');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('voters');
    }
};
