<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('areas', function (Blueprint $table) {
            $table->id();
            $table->string('district')->nullable();
            $table->string('upazila')->nullable();
            $table->string('city_corporation')->nullable();
            $table->string('ward_no')->nullable();
            $table->string('area_code')->nullable();
            $table->string('area_name_bn')->nullable();
            $table->enum('gender_type', ['male', 'female', 'mixed'])->default('mixed');
            $table->longText('raw_header_text')->nullable();
            $table->integer('total_voters')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('areas');
    }
};
