<?php

namespace Database\Factories;

use App\Models\Area;
use App\Models\SourceFile;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Voter>
 */
class VoterFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $banglaNames = ['শামীম আহমেদ', 'মাহমুদা আক্তার', 'রাকিবুল হাসান', 'সাবরিনা রহমান'];
        $fathers = ['মোঃ আবুল', 'মোঃ রশীদ', 'হাবিবুর রহমান', 'মোঃ করিম'];
        $mothers = ['মোসাঃ খালেদা', 'মোসাঃ রেবিনা', 'শাহানা খাতুন', 'মোসাঃ সালেহা'];
        $professions = ['কৃষক', 'ব্যবসায়ী', 'গৃহিণী', 'ছাত্র'];

        return [
            'area_id' => Area::factory(),
            'source_file_id' => SourceFile::factory(),
            'serial_no' => fake()->numberBetween(1, 500),
            'voter_no' => (string) fake()->numberBetween(100000000000, 999999999999),
            'name_bn' => fake()->randomElement($banglaNames),
            'name_en' => Str::title(fake()->name()),
            'father_name_bn' => fake()->randomElement($fathers),
            'mother_name_bn' => fake()->randomElement($mothers),
            'profession_bn' => fake()->randomElement($professions),
            'date_of_birth' => fake()->dateTimeBetween('-80 years', '-18 years')->format('Y-m-d'),
            'address_bn' => fake()->streetAddress(),
            'gender' => fake()->randomElement(['male', 'female', 'unknown']),
            'extra_json' => null,
        ];
    }
}
