<?php

namespace Database\Factories;

use App\Models\Area;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SourceFile>
 */
class SourceFileFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $filename = 'voter_' . fake()->numberBetween(100, 999) . '.pdf';

        return [
            'area_id' => Area::factory(),
            'original_filename' => $filename,
            'stored_path' => 'voter_pdfs/' . $filename,
            'mime_type' => 'application/pdf',
            'file_size' => fake()->numberBetween(50_000, 500_000),
            'parsed_successfully' => true,
            'parsed_at' => now(),
            'notes' => null,
        ];
    }
}
