<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Area>
 */
class AreaFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $district = fake()->randomElement(['গাজীপুর', 'ঢাকা', 'নরসিংদী', 'কুমিল্লা']);
        $upazila = fake()->randomElement(['সদর', 'সদর দক্ষিণ', 'মেঘনা', 'শিবপুর']);
        $areaName = fake()->randomElement(['নয়ানগাঁও', 'পশ্চিমপাড়া', 'উত্তর বাজার', 'কেন্দ্রীয় কলোনি']);

        return [
            'district' => $district,
            'upazila' => $upazila,
            'city_corporation' => null,
            'ward_no' => (string) fake()->numberBetween(1, 30),
            'area_code' => (string) fake()->numberBetween(1000, 9999),
            'area_name_bn' => $areaName,
            'gender_type' => fake()->randomElement(['male', 'female', 'mixed']),
            'raw_header_text' => "{$district}, {$upazila}, {$areaName}",
            'total_voters' => fake()->numberBetween(100, 1000),
        ];
    }
}
