<?php

$isWindows = PHP_OS_FAMILY === 'Windows';
$popplerBin = $isWindows
    ? base_path('tools/poppler/poppler-25.12.0/Library/bin')
    : null;

return [
    // OCR and PDF tooling defaults (no .env required)
    'VM_USE_OCR' => true,
    'VM_USE_PDFTOTEXT' => false,
    'VM_TESSERACT_PATH' => env('VM_TESSERACT_PATH', $isWindows
        ? 'C:\\Program Files\\Tesseract-OCR\\tesseract.exe'
        : '/usr/bin/tesseract'),
    'VM_PDFTOPPM_PATH' => env('VM_PDFTOPPM_PATH', $isWindows
        ? ($popplerBin ? $popplerBin.'/pdftoppm.exe' : 'pdftoppm.exe')
        : '/usr/bin/pdftoppm'),
    'VM_PDFTOTEXT_PATH' => env('VM_PDFTOTEXT_PATH', $isWindows
        ? ($popplerBin ? $popplerBin.'/pdftotext.exe' : 'pdftotext.exe')
        : '/usr/bin/pdftotext'),
    'VM_PDFINFO_PATH' => env('VM_PDFINFO_PATH', $isWindows
        ? ($popplerBin ? $popplerBin.'/pdfinfo.exe' : 'pdfinfo.exe')
        : '/usr/bin/pdfinfo'),
    'VM_TESSDATA_DIR' => env('VM_TESSDATA_DIR', $isWindows
        ? base_path('tools/tessdata')
        : '/usr/share/tesseract-ocr/5/tessdata'),
    'VM_IMAGEMAGICK_PATH' => env('VM_IMAGEMAGICK_PATH', $isWindows ? 'magick' : '/usr/bin/convert'),

    // OCR defaults (copied from previous .env values)
    'VM_OCR_PSM' => 6,
    'VM_OCR_DPI' => 200,
    'VM_OCR_LANG' => 'ben+eng',
    'VM_OCR_OEM' => 1,
    'VM_OCR_PSM_FALLBACK' => '6,11',
    'VM_OCR_USE_BOXES' => false,
    'VM_OCR_GRID_COLS' => 2,
    'VM_OCR_GRID_ROWS' => 4,
    'VM_OCR_GRID_FALLBACK' => '2x5',
    'VM_OCR_GRID_ALWAYS_FALLBACK' => false,
    'VM_OCR_MIN_VOTERS_PER_PAGE' => 8,
    'VM_OCR_MERGE_FULL_PAGE' => false,
    'VM_OCR_BOX_INSET' => 0.01,
    'VM_OCR_BOX_PAD' => 8,
    'VM_OCR_TOPLINE_FALLBACK' => false,
    'VM_OCR_TOPLINE_RATIO' => 0.35,
    'VM_OCR_TOPLINE_PSM' => 7,
    'VM_OCR_LINE_FALLBACK' => false,
    'VM_OCR_LINE_ROWS' => 9,
    'VM_OCR_LINE_OVERLAP' => 0.25,
    'VM_OCR_LINE_PSM' => 7,
    'VM_OCR_LINE_PSM_FALLBACK' => '6,11,4,12',
    'VM_OCR_LINE_PREPROCESS' => false,
    'VM_OCR_LINE_PREPROCESS_MODE' => 'gd',
    'VM_OCR_LINE_THRESHOLD' => 45,
    'VM_OCR_PREPROCESS' => false,
    'VM_OCR_PREPROCESS_MODE' => 'gd',
    'VM_OCR_PREPROCESS_THRESHOLD' => 55,
    'VM_OCR_PREPROCESS_THRESHOLD_FALLBACK' => 35,
    'VM_OCR_GRID_MARGIN_TOP' => 0.19,
    'VM_OCR_GRID_MARGIN_BOTTOM' => 0.14,
    'VM_OCR_GRID_MARGIN_LEFT' => 0.08,
    'VM_OCR_GRID_MARGIN_RIGHT' => 0.08,
    'VM_OCR_GRID_DETECT_LINES' => false,
    'VM_OCR_LINE_SAMPLE_STEP' => 3,
    'VM_OCR_LINE_DARK_THRESHOLD' => 120,
    'VM_OCR_LINE_DARK_RATIO' => 0.6,
    'VM_OCR_LINE_CLUSTER_GAP' => 12,
    'VM_OCR_SERIAL_MIN' => 1,
    'VM_OCR_SERIAL_MAX' => 9999,
    'VM_OCR_DESKEW' => '0%',
    'VM_OCR_DPI_FALLBACK' => 250,
    'VM_OCR_LINE_THRESHOLD_FALLBACK' => 35,
    'VM_OCR_PREPROCESS_CONTRAST' => -20,
    'VM_OCR_BAND_PREPROCESS_MODE' => 'gd',
    'VM_OCR_BAND_THRESHOLD' => 55,
    'VM_OCR_BAND_FALLBACK' => true,
    'VM_OCR_BOX_SCALE_FALLBACK' => 1.8,
    'VM_OCR_LINE_SCALE' => 1.0,
    'VM_OCR_LINE_ROWS_FALLBACK' => null,
    'VM_OCR_LINE_OVERLAP_FALLBACK' => null,
    'VM_OCR_LINE_SCALE_FALLBACK' => null,
    'VM_OCR_BAND_TOP' => 0.25,
    'VM_OCR_BAND_BOTTOM' => 0.75,
    'VM_OCR_BAND_SCALE' => 2.0,
    'VM_OCR_BAND_PSM' => 7,

    // PDF slip print defaults
    'VM_PDF_SLIP_DPI' => 200,
    'VM_PDF_SLIP_COLS' => 2,
    'VM_PDF_SLIP_ROWS' => 5,
    'VM_PDF_SLIP_CACHE_VERSION' => 21,
    'VM_PDF_SLIP_MARGIN_TOP' => 0.16,
    'VM_PDF_SLIP_MARGIN_BOTTOM' => 0.06,
    'VM_PDF_SLIP_MARGIN_LEFT' => 0.03,
    'VM_PDF_SLIP_MARGIN_RIGHT' => 0.03,
    'VM_PDF_SLIP_INSET' => 0.002,
    'VM_PDF_SLIP_BOX_HEIGHT_SCALE' => 1.0,
    'VM_PDF_SLIP_BOX_PAD' => 6,
    'VM_PDF_SLIP_DETECT_LINES' => true,
    'VM_PDF_SLIP_LINE_RATIO' => 0.65,
    'VM_PDF_SLIP_LINE_THRESHOLD' => 130,
    'VM_PDF_SLIP_LINE_GAP' => 13,
    'VM_PDF_SLIP_SCAN_TOP' => 0.05,
    'VM_PDF_SLIP_SCAN_BOTTOM' => 0.06,
    'VM_PDF_SLIP_AUTO_ROWS_MIN' => 5,
    'VM_PDF_SLIP_AUTO_ROWS_MAX' => 6,
];
