<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Voter extends Model
{
    /** @use HasFactory<\Database\Factories\VoterFactory> */
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'extra_json' => 'array',
        'date_of_birth' => 'date',
    ];

    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    public function sourceFile()
    {
        return $this->belongsTo(SourceFile::class);
    }
}
