<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SourceFile extends Model
{
    /** @use HasFactory<\Database\Factories\SourceFileFactory> */
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'parsed_successfully' => 'boolean',
        'parsed_at' => 'datetime',
        'import_started_at' => 'datetime',
        'import_finished_at' => 'datetime',
        'import_options' => 'array',
    ];

    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    public function voters()
    {
        return $this->hasMany(Voter::class);
    }
}
