<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PdfExport extends Model
{
    /** @use HasFactory<\Database\Factories\PdfExportFactory> */
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'started_at' => 'datetime',
        'finished_at' => 'datetime',
        'canceled_at' => 'datetime',
    ];

    public function sourceFile()
    {
        return $this->belongsTo(SourceFile::class);
    }

    public function candidate()
    {
        return $this->belongsTo(Candidate::class);
    }
}
