<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Area extends Model
{
    /** @use HasFactory<\Database\Factories\AreaFactory> */
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'total_voters' => 'integer',
    ];

    public function sourceFiles()
    {
        return $this->hasMany(SourceFile::class);
    }

    public function voters()
    {
        return $this->hasMany(Voter::class);
    }
}
