<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VoterStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'serial_no_pdf_bn' => ['required', 'string', 'max:20'],
            'voter_no' => ['nullable', 'string', 'max:255'],
            'name_bn' => ['required', 'string', 'max:255'],
            'name_en' => ['nullable', 'string', 'max:255'],
            'father_name_bn' => ['nullable', 'string', 'max:255'],
            'mother_name_bn' => ['nullable', 'string', 'max:255'],
            'profession_bn' => ['nullable', 'string', 'max:255'],
            'date_of_birth_bn' => ['nullable', 'string', 'max:50'],
            'address_bn' => ['nullable', 'string', 'max:255'],
            'gender' => ['nullable', 'in:male,female,unknown'],
            'area_id' => ['required_without:source_file_id', 'integer', 'exists:areas,id'],
            'source_file_id' => ['nullable', 'integer', 'exists:source_files,id'],
            'shift_later_serials' => ['nullable', 'boolean'],
        ];
    }
}
