<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class VoterInlineUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $field = (string) $this->input('field');

        $rules = [
            'field' => ['required', 'string', Rule::in([
                'serial_no_pdf_bn',
                'voter_no',
                'name_bn',
                'father_name_bn',
                'mother_name_bn',
                'profession_bn',
                'date_of_birth_bn',
                'address_bn',
                'area_id',
            ])],
        ];

        $rules['value'] = match ($field) {
            'serial_no_pdf_bn' => ['nullable', 'string', 'max:20'],
            'voter_no' => ['nullable', 'string', 'max:255'],
            'name_bn' => ['required', 'string', 'max:255'],
            'father_name_bn' => ['nullable', 'string', 'max:255'],
            'mother_name_bn' => ['nullable', 'string', 'max:255'],
            'profession_bn' => ['nullable', 'string', 'max:255'],
            'date_of_birth_bn' => ['nullable', 'string', 'max:50'],
            'address_bn' => ['nullable', 'string', 'max:255'],
            'area_id' => ['required', 'integer', 'exists:areas,id'],
            default => ['nullable', 'string', 'max:255'],
        };

        return $rules;
    }
}
