<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VoterFilterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'q' => ['nullable', 'string', 'max:255'],
            'area_id' => ['nullable', 'integer', 'exists:areas,id'],
            'profession_bn' => ['nullable', 'string', 'max:255'],
            'date_of_birth' => ['nullable', 'string', 'max:20'],
            'min_age' => ['nullable', 'integer', 'min:0', 'max:130'],
            'max_age' => ['nullable', 'integer', 'min:0', 'max:130'],
            'gender' => ['nullable', 'in:male,female,unknown'],
            'source_file_id' => ['nullable', 'integer', 'exists:source_files,id'],
            'candidate_id' => ['nullable', 'integer', 'exists:candidates,id'],
            'per_page' => ['nullable', 'integer', 'in:300,500,1000'],
        ];
    }
}
