<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckVoterMasterLicense
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $licensedDomain = env('VM_LICENSE_DOMAIN');
        $licenseKey = env('VM_LICENSE_KEY');
        $expectedKey = $licensedDomain
            ? hash_hmac('sha256', $licensedDomain, 'VoterMasterSecretSalt')
            : null;

        $host = $request->getHost();
        $domainMatches = $licensedDomain && ($host === $licensedDomain || ($licensedDomain === 'localhost' && $host === '127.0.0.1'));
        $keyMatches = $expectedKey && hash_equals($expectedKey, (string) $licenseKey);

        if (! $domainMatches || ! $keyMatches) {
            return response()->view('license_denied', [], 403);
        }

        return $next($request);
    }
}
