<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function edit()
    {
        $slipHeader = Setting::getValue('slip_header_bn');
        $slipFooter = Setting::getValue('slip_footer_bn');

        return view('admin.settings.edit', compact('slipHeader', 'slipFooter'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'slip_header_bn' => ['nullable', 'string', 'max:255'],
            'slip_footer_bn' => ['nullable', 'string', 'max:255'],
        ]);

        Setting::setValue('slip_header_bn', $validated['slip_header_bn'] ?? null);
        Setting::setValue('slip_footer_bn', $validated['slip_footer_bn'] ?? null);

        return back()->with('status', 'Settings updated.');
    }
}
