<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\SourceFile;
use App\Models\Voter;

class DashboardController extends Controller
{
    public function index()
    {
        $data = [
            'totalVoters' => Voter::count(),
            'totalAreas' => Area::count(),
            'latestFiles' => SourceFile::withCount('voters')->with('area')->latest()->take(5)->get(),
        ];

        return view('admin.dashboard', $data);
    }
}
