<?php

namespace App\Http\Controllers;

use App\Models\Area;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    public function index()
    {
        $areas = Area::latest()->paginate(15);

        return view('admin.areas.index', compact('areas'));
    }

    public function create()
    {
        $area = new Area();

        return view('admin.areas.create', compact('area'));
    }

    public function store(Request $request)
    {
        $data = $this->validateArea($request);
        Area::create($data);

        return redirect()->route('admin.areas.index')->with('status', 'এলাকা সংরক্ষণ করা হয়েছে।');
    }

    public function show(Area $area)
    {
        return redirect()->route('admin.areas.edit', $area);
    }

    public function edit(Area $area)
    {
        return view('admin.areas.edit', compact('area'));
    }

    public function update(Request $request, Area $area)
    {
        $data = $this->validateArea($request);
        $area->update($data);

        return redirect()->route('admin.areas.index')->with('status', 'এলাকা হালনাগাদ করা হয়েছে।');
    }

    public function destroy(Area $area)
    {
        if ($area->voters()->exists() || $area->sourceFiles()->exists()) {
            return back()->withErrors(['area' => 'এই এলাকা মুছা যাবে না, সংশ্লিষ্ট ভোটার/ফাইল আছে।']);
        }

        $area->delete();

        return redirect()->route('admin.areas.index')->with('status', 'এলাকা মুছে ফেলা হয়েছে।');
    }

    private function validateArea(Request $request): array
    {
        return $request->validate([
            'district' => ['nullable', 'string', 'max:255'],
            'upazila' => ['nullable', 'string', 'max:255'],
            'city_corporation' => ['nullable', 'string', 'max:255'],
            'ward_no' => ['nullable', 'string', 'max:50'],
            'area_code' => ['nullable', 'string', 'max:50'],
            'area_name_bn' => ['required', 'string', 'max:255'],
            'center_name_bn' => ['nullable', 'string', 'max:255'],
            'gender_type' => ['required', 'in:male,female,mixed'],
            'raw_header_text' => ['nullable', 'string'],
            'total_voters' => ['nullable', 'integer'],
        ], [], [
            'district' => 'জেলা',
            'upazila' => 'উপজেলা/থানা',
            'city_corporation' => 'সিটি কর্পোরেশন',
            'ward_no' => 'ওয়ার্ড নং',
            'area_code' => 'এরিয়া কোড',
            'area_name_bn' => 'এলাকার নাম',
            'center_name_bn' => 'কেন্দ্রের নাম',
            'gender_type' => 'লিঙ্গ প্রকার',
            'raw_header_text' => 'হেডার টেক্সট',
            'total_voters' => 'মোট ভোটার',
        ]);
    }
}
